/*
 * Created on May 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter;

/**
 * A boolean value converter uses the {@link Boolean#parseBoolean(String)} for conversion between
 * Boolean and String values.
 * 
 * @author Vijay Silva
 */
public class BooleanConverter implements IValueConverter<Boolean> {

	/**
	 * Constructor
	 */
	public BooleanConverter() {
	}

	@Override
	public String getStringValue(Boolean typedValue) {
		return (typedValue == null) ? null : typedValue.toString();
	}

	@Override
	public Boolean getTypedValue(String value) {
		return (value == null || value.trim().length() == 0) ? null : new Boolean(value.trim());
	}
}
