package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;

/**
 * @author esunpur
 *
 */
public class ErrorPanel extends MessagePanel {

	private static final String ERROR_PANEL_STYLE = "nwt-MessagePanel-error"; 
	private static final String ERROR_LABEL_STYLE = "nwt-ErrorMessage"; 
	
	protected HTMLWidget errorMessageHTML;
	
	public ErrorPanel() {
		super();
		
		scrollPanel.addStyleName(ERROR_PANEL_STYLE);
		mainPanel.remove(messageLabel);
		
		errorMessageHTML = new HTMLWidget();
		mainPanel.add(errorMessageHTML);
		errorMessageHTML.addStyleName(ERROR_LABEL_STYLE);
	}
	
	/**
	 * 
	 * @param text
	 */
	public void setText(String text) {
		errorMessageHTML.setText(text);
	}
	
	/**
	 * 
	 * @param html
	 */
	public void setHTML(String html) {
		errorMessageHTML.setHTML(html);
	}	
}
