/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.persist;

import com.tandbergtv.neptune.realm.persist.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CMS_MODULE", uniqueConstraints={@UniqueConstraint(columnNames={"MODULENAME"}), @UniqueConstraint(columnNames={"DISPLAYNAME"})})
@NamedQueries(value={@NamedQuery(name="Module.FindByName", query="SELECT module FROM Module module WHERE module.name = :name"), @NamedQuery(name="Module.FindAll", query="SELECT module FROM Module module"), @NamedQuery(name="Module.FindAllOrderByDisplayName", query="SELECT module FROM Module module ORDER BY module.displayName")})
public class Module
implements Serializable {
    private static final long serialVersionUID = -7960347958825347186L;
    private Long id;
    private String name;
    private String displayName;
    private String displayKey;
    private String providerClassName;
    private List<Permission> permissions;

    public Module() {
        this(null, null);
    }

    public Module(String name, String displayName) {
        this(name, displayName, null);
    }

    public Module(String name, String displayName, List<Permission> permissions) {
        this.setName(name);
        this.setDisplayName(displayName);
        this.setPermissionList(permissions);
    }

    @Id
    @Column(name="MODULEID")
    @SequenceGenerator(name="ModuleID Sequence Generator", sequenceName="CMS_MODULE_SEQ", allocationSize=20)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ModuleID Sequence Generator")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="MODULENAME", nullable=false, unique=true)
    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="DISPLAYNAME", unique=true, nullable=false)
    @Basic(optional=false)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Transient
    public String getDisplayKey() {
        return this.displayKey;
    }

    public void setDisplayKey(String displayKey) {
        this.displayKey = displayKey;
    }

    @Transient
    public String getProviderClassName() {
        return this.providerClassName;
    }

    public void setProviderClassName(String providerClassName) {
        this.providerClassName = providerClassName;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, mappedBy="module")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="order")
    protected List<Permission> getPermissionList() {
        return this.permissions;
    }

    protected void setPermissionList(List<Permission> permissions) {
        if (permissions == null) {
            permissions = new ArrayList<Permission>();
        }
        this.permissions = permissions;
    }

    @Transient
    public List<Permission> getPermissions() {
        return new ArrayList<Permission>(this.permissions);
    }

    public void addPermission(Permission permission) {
        this.addPermission(permission, this.permissions.size());
    }

    public void addPermission(Permission permission, int order) {
        int permissionCount = this.permissions.size();
        if (order < 0 || order > permissionCount) {
            String msg = "The permission order must a number between 0 and the number of permissions(" + permissionCount + "), invalid value: " + order + " specified.";
            throw new IllegalArgumentException(msg);
        }
        order = this.permissions.size();
        permission.setModule(this);
        this.permissions.add(permission);
        this.updatePermissionOrder();
    }

    public Permission removePermission(Permission permission) {
        Permission internalPermission = null;
        int index = this.permissions.indexOf(permission);
        if (index != -1) {
            internalPermission = this.permissions.remove(index);
            internalPermission.setModule(null);
            internalPermission.setOrder(-1);
            this.updatePermissionOrder();
        }
        return internalPermission;
    }

    public void removeAllPermissions() {
        for (Permission permission : this.permissions) {
            permission.setModule(null);
            permission.setOrder(-1);
        }
        this.permissions.clear();
    }

    protected void updatePermissionOrder() {
        for (int index = 0; index < this.permissions.size(); ++index) {
            this.permissions.get(index).setOrder(index);
        }
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() * 7 + 29 : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Module)) {
            return false;
        }
        Module other = (Module)obj;
        return this.getId() != null && this.getId().equals(other.getId());
    }
}

