/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.validation;

import com.tandbergtv.neptune.configuration.service.JSONToMapConverter;
import com.tandbergtv.neptune.configuration.service.SettingToJSONConverter;
import com.tandbergtv.neptune.configuration.settings.entity.ComplexSetting;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.validator.ComplexSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.SettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.SimpleSettingsValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import com.tandbergtv.neptune.configuration.validation.SettingsValidatorFactory;
import com.tandbergtv.neptune.configuration.validation.ValidationGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class SettingsValidatorService {
    protected Set<ValidationGroup> validationsToSkip;
    private static final Logger logger = Logger.getLogger(SettingsValidatorService.class);
    private static final String PATH_SEPARATOR = ".";

    public SettingsValidatorService(ValidationGroup ... validationsToSkip) {
        this.validationsToSkip = new HashSet<ValidationGroup>(validationsToSkip.length);
        for (ValidationGroup validation : validationsToSkip) {
            this.validationsToSkip.add(validation);
        }
    }

    public SettingsValidatorService() {
        this.validationsToSkip = Collections.emptySet();
    }

    protected List<ValidationResult> validateSetting(String parentPath, SettingDefinition def, Map<String, String> values) {
        ArrayList<ValidationResult> errors;
        block12: {
            String currentPath;
            block13: {
                ComplexSetting complex;
                block14: {
                    errors = new ArrayList<ValidationResult>();
                    currentPath = def.getName();
                    if (!parentPath.isEmpty()) {
                        currentPath = parentPath + PATH_SEPARATOR + currentPath;
                    }
                    if (!(def instanceof ComplexSetting)) break block13;
                    complex = (ComplexSetting)def;
                    boolean isArray = complex.getMax() == null || complex.getMax() > 1;
                    boolean bl = isArray = !parentPath.isEmpty() && isArray;
                    if (!isArray) break block14;
                    int arrayLength = -1;
                    String arrayStart = currentPath + "[";
                    for (String key : values.keySet()) {
                        if (!key.startsWith(arrayStart)) continue;
                        int arrayCloseIndex = key.indexOf("]", arrayStart.length());
                        String currentIndexStr = key.substring(arrayStart.length(), arrayCloseIndex);
                        int currentIndex = Integer.parseInt(currentIndexStr);
                        if (currentIndex <= arrayLength) continue;
                        arrayLength = currentIndex;
                    }
                    if (arrayLength < 0) break block12;
                    for (int i = 0; i <= arrayLength; ++i) {
                        for (SettingDefinition sub : complex.getSettings()) {
                            String currentIndexedPath = currentPath + "[" + i + "]";
                            errors.addAll(this.validateSetting(currentIndexedPath, sub, values));
                        }
                    }
                    break block12;
                }
                for (SettingDefinition sub : complex.getSettings()) {
                    errors.addAll(this.validateSetting(currentPath, sub, values));
                }
                break block12;
            }
            if (values.containsKey(currentPath)) {
                List<Class<? extends SettingValidator>> validators = SettingsValidatorFactory.getInstance().getValidatorsFor(def);
                SettingValidator validator = null;
                if (validators != null) {
                    for (Class<? extends SettingValidator> validatorClass : validators) {
                        try {
                            validator = validatorClass.newInstance();
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error instantiating validator class: " + validatorClass.getCanonicalName()), (Throwable)e);
                        }
                        if (validator == null) continue;
                        try {
                            validator.setOtherSettingsValues(values);
                            ValidationResult result = validator.validate(def, values.get(currentPath));
                            if (!result.hasFailed()) continue;
                            errors.add(result);
                            break;
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error running validation: " + validatorClass.getCanonicalName() + " for setting: " + def.getName()), (Throwable)e);
                        }
                    }
                }
            }
        }
        return errors;
    }

    public List<ValidationResult> validateSettings(SettingGroup group, Map<String, String> values) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>();
        SettingToJSONConverter settingToJSON = new SettingToJSONConverter(group, values);
        JSONToMapConverter jsonToMap = new JSONToMapConverter((JsonNode)settingToJSON.convert());
        errors.addAll(this.validateGroupConsistency(group, jsonToMap.convert()));
        for (SettingDefinition def : group.getSettings()) {
            errors.addAll(this.validateSetting("", def, jsonToMap.convert()));
        }
        return errors;
    }

    protected List<ValidationResult> validateGroupConsistency(SettingGroup group, Map<String, String> values) {
        List errors = Collections.emptyList();
        if (group.getSettings() != null && !group.getSettings().isEmpty()) {
            SettingDefinition def = (SettingDefinition)group.getSettings().get(0);
            ComplexSettingValidator groupValidator = null;
            if (def instanceof ComplexSetting) {
                if (!this.validationsToSkip.contains((Object)ValidationGroup.COMPLEX_GROUP_UNDEFINED_SETTINGS)) {
                    groupValidator = new ComplexSettingValidator();
                }
            } else if (!this.validationsToSkip.contains((Object)ValidationGroup.SIMPLE_GROUP_UNDEFINED_SETTINGS)) {
                groupValidator = new SimpleSettingsValidator();
            }
            if (groupValidator != null) {
                errors = groupValidator.validate(group, values);
            }
        }
        return errors;
    }
}

