/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserConfigurationMode;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.realm.search.EntitySearchService;
import com.tandbergtv.neptune.usermgmt.ejb.DigestUtil;
import com.tandbergtv.neptune.usermgmt.ejb.UserSynchronizer;
import com.tandbergtv.neptune.usermgmt.ejb.UserValidator;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.service.IUserActionCallback;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.usermgmt.service.UserActionException;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

@Local(value={IUserManager.class})
@Stateless
@TransactionAttribute
public class UserManager
implements IUserManager {
    private static final Logger logger = Logger.getLogger(UserManager.class);
    private static final Character ESCAPE_CHARACTER = new Character('!');
    private static final String ADMIN_USER_ACTIVE_STATUS_ERROR_CODE = "UserAction-ADMIN_ACTIVE_STATUS_CHANGE";
    private static final String ADMIN_USER_DELETE_ERROR_CODE = "UserAction-ADMIN_USER_DELETE";
    private static final String EXTERNAL_USER_ACTIVE_STATUS_ERROR_CODE = "UserAction-EXTERNAL_USER_ACTIVE_STATUS_CHANGE";
    private static final String INVALID_KEY_ERROR_CODE = "UserAction-INVALID_USERKEY";
    private static final String SEAT_LICENSE_ERROR_CODE = "UserAction-SEAT_LICENSE";
    private static final String UNDEFINED_CONFIG_MODE_ERROR_CODE = "UserAction-UNDEFINED_MODE";
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    @EJB
    private IRealmConfigurationService realmConfiguration;
    @EJB
    private ILicenseManager licenseManager;
    @EJB
    private IAuthorizationService authorizationService;
    private final EntitySearchService<User> searchService = new EntitySearchService<User>(User.class, User.ID_FIELD_NAME);
    private final UserSynchronizer synchronizer = new UserSynchronizer(this);
    private final UserValidator validator = new UserValidator(this);

    @PageTarget(entityClass="User", entityName="user")
    public List<User> getUsers() {
        List<User> list;
        Object[] objectArray = new Object[]{UserManager.class.getDeclaredMethod("getUsers", new Class[0]).getAnnotation(PageTarget.class)};
        PagingAspect.ajc$cflowStack$0.push(objectArray);
        try {
            String string = "SELECT user FROM User user";
            EntityManager entityManager = this.entityManager;
            Query query = PagingAspect.ajc$cflowStack$0.isValid() ? UserManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
            List users = query.getResultList();
            list = this.synchronizer.trySynchronize(users);
        }
        finally {
            PagingAspect.ajc$cflowStack$0.pop();
        }
        return list;
    }

    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        String string = "SELECT user FROM User user, IN(user.roles) role, IN(role.permissions) permission where permission.name = :permissionName and permission.module.name = :moduleName";
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? UserManager.createQuery_aroundBody3$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        query.setParameter("moduleName", (Object)moduleName);
        query.setParameter("permissionName", (Object)permissionName);
        List users = query.getResultList();
        return this.synchronizer.trySynchronize(users);
    }

    public SearchResult<User> getUsers(SearchMetadata searchMetadata) {
        String whereClause = "WHERE (hidden=0)";
        return this.getSearchResult("user", whereClause, null, searchMetadata);
    }

    public SearchResult<User> getUsers(String userCriteria, SearchMetadata searchMetadata) {
        if (userCriteria == null || userCriteria.trim().length() == 0) {
            return new SearchResult(new ArrayList(), 0);
        }
        String alias = "user";
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("WHERE ");
        queryBuf.append("(");
        queryBuf.append("LOWER(").append(alias).append(".").append("userName").append(")");
        queryBuf.append(" LIKE :searchString ESCAPE :escapeCharacter");
        queryBuf.append(" OR ");
        queryBuf.append("LOWER(").append(alias).append(".").append("firstName").append(")");
        queryBuf.append(" LIKE :searchString ESCAPE :escapeCharacter");
        queryBuf.append(" OR ");
        queryBuf.append("LOWER(").append(alias).append(".").append("lastName").append(")");
        queryBuf.append(" LIKE :searchString ESCAPE :escapeCharacter");
        queryBuf.append(")");
        String searchString = this.formatCriteria(userCriteria);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("searchString", searchString);
        parameters.put("escapeCharacter", ESCAPE_CHARACTER);
        return this.getSearchResult(alias, queryBuf.toString(), parameters, searchMetadata);
    }

    public User getUser(UserKey userKey) {
        User user = this.find(userKey.getId());
        return this.synchronizer.trySynchronize(user);
    }

    public User getUser(String userName) {
        User user = this.findByUserName(userName);
        return this.synchronizer.trySynchronize(user);
    }

    public User getUserByExternalKey(String externalKey) {
        if (externalKey == null) {
            throw new IllegalArgumentException("externalKey cannot be null.");
        }
        User user = this.findByExternalKey(externalKey);
        return this.synchronizer.trySynchronize(user);
    }

    public User createUser(User user) throws ValidationException {
        if (user.getUserKey().isAssigned()) {
            throw new IllegalArgumentException("Cannot create user with assigned id.");
        }
        this.enforceSeatLicenseConstraint();
        user.setSyncDate(null);
        this.synchronizer.trySynchronize(user);
        this.validator.validateUser(user);
        this.encryptPassword(user);
        this.entityManager.persist((Object)user);
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onCreate(user);
        }
        return user;
    }

    private void enforceSeatLicenseConstraint() {
        int userCount;
        Integer seatLicense = null;
        try {
            String value = this.licenseManager.getProperty("seatLicense");
            if (value != null && !value.trim().isEmpty()) {
                seatLicense = Integer.parseInt(value.trim());
            }
        }
        catch (Exception e) {
            String msg = "Failure getting the seat license limitation, error: ";
            logger.warn((Object)(msg + e.getLocalizedMessage()), (Throwable)e);
            seatLicense = 0;
        }
        if (seatLicense != null && (userCount = this.searchService.getEntityCount(this.entityManager, "user", null, null)) >= seatLicense) {
            String message = "The licensed number of users(" + seatLicense + ") has been reached, cannot create new user.";
            UserActionException e = new UserActionException(SEAT_LICENSE_ERROR_CODE, message);
            e.getParameters().add(Integer.toString(seatLicense));
            e.getParameters().add(Integer.toString(userCount));
            throw e;
        }
    }

    public User updateUser(User user) throws ValidationException {
        return this.updateUser(user, false);
    }

    public User updateUserWithPassword(User user) throws ValidationException {
        return this.updateUser(user, true);
    }

    private User updateUser(User user, boolean persistPassword) throws ValidationException {
        if (!user.getUserKey().isAssigned()) {
            throw new IllegalArgumentException("Cannot update user without assigned Id.");
        }
        User persistedUser = this.getPersistedUser(user);
        if (persistedUser == null) {
            String msg = "No user exists for key" + user.getUserKey();
            UserActionException e = new UserActionException(INVALID_KEY_ERROR_CODE, msg);
            e.getParameters().add(String.valueOf(user.getId()));
            throw e;
        }
        if (persistPassword) {
            this.validator.validateUser(user, persistedUser);
            this.encryptPassword(user);
        } else {
            user.setPassword(persistedUser.getPassword());
            user.setPasswordModifiedDate(persistedUser.getPasswordModifiedDate());
            this.validator.validateUserWithoutPassword(user, persistedUser);
        }
        user.setSyncDate(null);
        user = this.synchronizer.trySynchronize(user);
        User updatedUser = (User)this.entityManager.merge((Object)user);
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onUpdate(updatedUser);
        }
        return updatedUser;
    }

    public boolean deleteUser(UserKey userKey) {
        User user = this.find(userKey.getId());
        if (user == null) {
            return false;
        }
        String adminUserName = this.getAdministratorUserName();
        if (adminUserName != null && adminUserName.equals(user.getUserName())) {
            String msg = "The user '" + user.getUserName() + "' is the system administrator user, and cannot be deleted.";
            UserActionException e = new UserActionException(ADMIN_USER_DELETE_ERROR_CODE, msg);
            e.getParameters().add(String.valueOf(user.getId()));
            e.getParameters().add(String.valueOf(user.getUserName()));
            throw e;
        }
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onBeforeDelete(user);
        }
        this.entityManager.remove((Object)user);
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onDelete(user);
        }
        return true;
    }

    public boolean deleteUsers(UserKey ... userKeys) {
        boolean result = true;
        for (UserKey userKey : userKeys) {
            result &= this.deleteUser(userKey);
        }
        return result;
    }

    public User setActiveStatus(UserKey userKey, boolean active) {
        User user = this.getUser(userKey);
        if (user == null) {
            String msg = "No user exists for key" + userKey;
            UserActionException e = new UserActionException(INVALID_KEY_ERROR_CODE, msg);
            e.getParameters().add(String.valueOf(userKey.getId()));
            throw e;
        }
        if (user.getExternalKey() != null) {
            UserActionException e = new UserActionException(EXTERNAL_USER_ACTIVE_STATUS_ERROR_CODE, "The active status cannot be changed for an external user.");
            e.getParameters().add(String.valueOf(userKey.getId()));
            e.getParameters().add(String.valueOf(user.getUserName()));
            e.getParameters().add(String.valueOf(user.getExternalKey()));
            throw e;
        }
        String adminUserName = this.getAdministratorUserName();
        if (adminUserName != null && adminUserName.equals(user)) {
            UserActionException e = new UserActionException(ADMIN_USER_ACTIVE_STATUS_ERROR_CODE, "The active status cannot be changed for the system administrator user.");
            e.getParameters().add(String.valueOf(userKey.getId()));
            e.getParameters().add(String.valueOf(user.getUserName()));
            throw e;
        }
        user.setActive(active);
        return user;
    }

    @Deprecated
    public boolean isReadOnly() {
        return false;
    }

    @Deprecated
    public boolean isReadOnly(User user) {
        return false;
    }

    public String getAdministratorUserName() {
        return this.realmConfiguration.getAdministratorUserName();
    }

    public User getAdministratorUser() {
        String userName = this.getAdministratorUserName();
        return userName != null ? this.getUser(userName) : null;
    }

    public UserConfigurationMode getUserConfigurationMode() {
        UserConfigurationFactory factory = UserConfigurationFactory.getFactory();
        UserConfigurationMode mode = factory.getUserConfigurationMode();
        if (mode == null) {
            String msg = "No user configuration mode defined by UserConfigurationFactory implementation: " + factory.getClass().getName();
            throw new UserActionException(UNDEFINED_CONFIG_MODE_ERROR_CODE, msg);
        }
        return mode;
    }

    public User synchronizeUser(UserKey userKey) {
        User user = this.find(userKey.getId());
        if (user == null) {
            UserActionException e = new UserActionException(INVALID_KEY_ERROR_CODE, "No user exists for key" + userKey);
            e.getParameters().add(String.valueOf(userKey.getId()));
            throw e;
        }
        return this.synchronizer.synchronize(user);
    }

    User findByExternalKey(String externalKey) {
        if (externalKey == null) {
            return null;
        }
        User match = null;
        Query query = this.entityManager.createNamedQuery("User.FindByExternalKey");
        query.setParameter("externalKey", (Object)externalKey);
        try {
            match = (User)query.getSingleResult();
        }
        catch (NoResultException nre) {
            match = null;
        }
        return match;
    }

    void updateUserRoles(User user) {
        String queryString;
        Set roles = user.getRoles();
        if (roles == null || roles.isEmpty()) {
            return;
        }
        HashSet<Long> roleIds = new HashSet<Long>();
        for (Role role : roles) {
            roleIds.add(role.getId());
        }
        String string = queryString = "SELECT role FROM Role role WHERE role.id IN (:roleIds)";
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? UserManager.createQuery_aroundBody5$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        query.setParameter("roleIds", roleIds);
        List managedRoles = query.getResultList();
        user.setRoles(new HashSet(managedRoles));
    }

    String getCurrentUser() {
        return this.authorizationService.getUserName();
    }

    private String formatCriteria(String criteria) {
        String searchString = criteria.trim().toLowerCase();
        String pattern = "[" + ESCAPE_CHARACTER + "_%]";
        String replacement = ESCAPE_CHARACTER + "$0";
        searchString = searchString.replaceAll(pattern, replacement);
        searchString = "%" + searchString + "%";
        return searchString;
    }

    private SearchResult<User> getSearchResult(String alias, String whereClause, Map<String, Object> parameters, SearchMetadata metadata) {
        List<User> users = this.searchService.getEntityList(this.entityManager, alias, whereClause, parameters, metadata);
        users = this.synchronizer.trySynchronize(users);
        int count = this.searchService.getEntityCount(this.entityManager, alias, whereClause, parameters);
        return new SearchResult(users, count);
    }

    private User find(Long userId) {
        return (User)this.entityManager.find(User.class, (Object)userId);
    }

    private User findByUserName(String userName) {
        User match = null;
        Query query = this.entityManager.createNamedQuery("User.FindByUserName");
        query.setParameter("userName", (Object)userName);
        try {
            match = (User)query.getSingleResult();
        }
        catch (NoResultException nre) {
            match = null;
        }
        return match;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private User getPersistedUser(User user) {
        return this.find(user.getId());
    }

    private void encryptPassword(User user) {
        if (user.getPassword() != null) {
            String encryptedPassword = DigestUtil.Digest(user.getPassword(), "SHA");
            user.setPassword(encryptedPassword);
        }
        user.setPasswordModifiedDate(new Date());
    }

    private ServiceLoader<IUserActionCallback> getUserActionCallbacks() {
        return ServiceLoader.load(IUserActionCallback.class);
    }

    private static final /* synthetic */ Query createQuery_aroundBody1$advice(UserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }

    private static final /* synthetic */ Query createQuery_aroundBody3$advice(UserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }

    private static final /* synthetic */ Query createQuery_aroundBody5$advice(UserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }
}

