/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.networkmanagement.ejb.dao;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.networkelements.entity.NetworkElement;
import com.tandbergtv.neptune.networkelements.entity.NetworkElementStatus;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NetworkElementsDAO {
    private Logger logger = Logger.getLogger(NetworkElementsDAO.class);
    protected static final String SCRIPTS_FOLDER = "scripts/veritas";
    protected static final String CLUSTER_REDUNDANCY_SCRIPT = "vcscheck.sh";
    protected static final String CLUSTER_ELEMENTS_STATUS_SCRIPT = "cluster_info.sh";
    protected static final String FAILOVER_NOW_SCRIPT = "failovernow.sh";
    protected static final String SWITCH_AUTO_FAILOVER_SCRIPT = "autofailover.sh";

    protected File getScriptsFolder() {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File folder = new File(configReaderService.getInstallDirectory(), SCRIPTS_FOLDER);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkElementStatus getRedundancyStatus() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Fetching cluster redundancy status. ");
        }
        String code = "";
        InputStream in = null;
        File redundancyFile = null;
        try {
            redundancyFile = new File(this.getScriptsFolder(), CLUSTER_REDUNDANCY_SCRIPT);
            if (redundancyFile.exists()) {
                ProcessBuilder builder = new ProcessBuilder("sh", "-c", redundancyFile.getAbsolutePath());
                Process proc = builder.start();
                InputStreamReader is = new InputStreamReader(proc.getInputStream());
                BufferedReader br = new BufferedReader(is);
                String lastLine = code = br.readLine();
                while (lastLine != null) {
                    lastLine = br.readLine();
                    if (lastLine == null) continue;
                    code = lastLine;
                }
            } else {
                code = String.valueOf(NetworkElementStatus.DISABLED.getStatusValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error running cluster redundancy script: " + redundancyFile), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        NetworkElementStatus reduncancyStatus = null;
        try {
            int redundancyStatusCode = Integer.parseInt(code);
            reduncancyStatus = NetworkElementStatus.valueOf((int)redundancyStatusCode);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("Cluster redundancy in invalid state: " + code));
        }
        if (reduncancyStatus == null) {
            reduncancyStatus = NetworkElementStatus.FAILED;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cluster redundancy status fetched: " + reduncancyStatus));
        }
        return reduncancyStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkElement> getClusterElementsStatus() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Fetching cluster elements status. ");
        }
        InputStream in = null;
        File clusterStatus = null;
        ArrayList<NetworkElement> networkElements = new ArrayList<NetworkElement>();
        try {
            clusterStatus = new File(this.getScriptsFolder(), CLUSTER_ELEMENTS_STATUS_SCRIPT);
            if (clusterStatus.exists()) {
                ProcessBuilder builder = new ProcessBuilder("sh", "-c", clusterStatus.getAbsolutePath());
                Process proc = builder.start();
                InputStreamReader is = new InputStreamReader(proc.getInputStream());
                BufferedReader br = new BufferedReader(is);
                String line = br.readLine();
                while (line != null) {
                    networkElements.add(this.parseNetworkElement(line));
                    line = br.readLine();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error running cluster redundancy script: " + clusterStatus), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cluster elements fetched: " + networkElements));
        }
        return networkElements;
    }

    protected NetworkElement parseNetworkElement(String line) {
        String[] split = line.split(",");
        NetworkElement ne = new NetworkElement();
        ne.setStatus(NetworkElementStatus.valueOf((int)Integer.parseInt(split[0])));
        ne.setName(split[1]);
        ne.setMode(split[2]);
        ne.setIp(split[3]);
        return ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean failOverNow() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Failing over to a redundant node. ");
        }
        InputStream in = null;
        File failOverNowScript = null;
        Boolean hasFailedOver = Boolean.FALSE;
        try {
            failOverNowScript = new File(this.getScriptsFolder(), FAILOVER_NOW_SCRIPT);
            if (failOverNowScript.exists()) {
                int exitCode;
                ProcessBuilder builder = new ProcessBuilder("sh", "-c", failOverNowScript.getAbsolutePath());
                Process proc = builder.start();
                String scriptOutput = this.readInputStream(proc.getInputStream());
                String scriptErr = this.readInputStream(proc.getErrorStream());
                String logMessage = "";
                if (scriptOutput != null && !scriptOutput.isEmpty()) {
                    logMessage = logMessage + " Script Output: " + scriptOutput;
                }
                if (scriptErr != null && !scriptErr.isEmpty()) {
                    logMessage = logMessage + " Script Error Stream: " + scriptErr;
                }
                if ((exitCode = proc.waitFor()) != 0) {
                    hasFailedOver = Boolean.FALSE;
                    this.logger.error((Object)("Error while failing over." + logMessage + " ExitCode: " + exitCode));
                } else {
                    hasFailedOver = Boolean.TRUE;
                    this.logger.info((Object)("Failing over to a new node." + logMessage));
                }
            } else {
                this.logger.error((Object)("Cannot find failover script at: " + failOverNowScript.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error running failover script: " + failOverNowScript), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        return hasFailedOver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputStream(InputStream in) throws Exception {
        StringBuilder scriptOutput = new StringBuilder();
        try {
            InputStreamReader is = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(is);
            String line = br.readLine();
            while (line != null) {
                scriptOutput.append(line);
                line = br.readLine();
            }
        }
        finally {
            in.close();
        }
        return scriptOutput.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchAutoFailOverPreference() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Failing over to a redundant node. ");
        }
        InputStream in = null;
        File autoFailoverSwitchScript = null;
        try {
            autoFailoverSwitchScript = new File(this.getScriptsFolder(), SWITCH_AUTO_FAILOVER_SCRIPT);
            if (autoFailoverSwitchScript.exists()) {
                ProcessBuilder builder = new ProcessBuilder("sh", "-c", autoFailoverSwitchScript.getAbsolutePath());
                Process proc = builder.start();
                InputStreamReader is = new InputStreamReader(proc.getInputStream());
                BufferedReader br = new BufferedReader(is);
                StringBuilder scriptOutput = new StringBuilder();
                String line = br.readLine();
                scriptOutput.append(line);
                while (line != null) {
                    line = br.readLine();
                    scriptOutput.append(line);
                }
                this.logger.info((Object)("Auto Failover preference switched. " + scriptOutput));
            } else {
                this.logger.error((Object)("Cannot find auto failover switch script at: " + autoFailoverSwitchScript.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error running auto failover switch script: " + autoFailoverSwitchScript), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

