/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.validation;

import com.tandbergtv.neptune.configuration.settings.validator.ValidationMessage;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class SettingValidationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<ValidationResult> validationErrors;

    public SettingValidationException(List<ValidationResult> errors) {
        this.validationErrors = errors;
    }

    public SettingValidationException(ValidationResult error) {
        this.validationErrors = new ArrayList<ValidationResult>();
        this.validationErrors.add(error);
    }

    public List<ValidationResult> getValidationErrors() {
        return this.validationErrors;
    }

    public String getValidationErrorsAsJSON() {
        StringBuffer errosJSON = new StringBuffer();
        List<String> erros = this.getValidationErros(this.validationErrors);
        errosJSON.append("{\"Errors\": { \"Error\":[ \n ");
        for (String error : erros) {
            errosJSON.append("\"");
            errosJSON.append(error);
            errosJSON.append("\",");
        }
        errosJSON.append("]}}");
        return errosJSON.toString().replace(",]", "]");
    }

    private List<String> getValidationErros(List<ValidationResult> validationErrors) {
        ArrayList<String> errors = new ArrayList<String>();
        for (ValidationResult error : validationErrors) {
            List<ValidationMessage> msgs = error.getMessages();
            for (ValidationMessage msg : msgs) {
                if (msg.getMessage() == null) continue;
                errors.add(msg.getMessage());
            }
        }
        return errors;
    }
}

