/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.FloatSetting;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class FloatRangeValidator
extends AbstractSettingValidator {
    @Override
    public ValidationResult validate(SettingDefinition s, String value) {
        FloatSetting setting = (FloatSetting)s;
        ValidationResult result = new ValidationResult();
        if (value != null && !value.trim().isEmpty()) {
            Float max;
            float floatValue = Float.parseFloat(value);
            Float min = setting.getMinimumValue();
            if (min != null && floatValue < min.floatValue()) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(2);
                params.add(setting.getDisplayName());
                ArrayList<LocalizedString> minParam = new ArrayList<LocalizedString>(1);
                minParam.add(new LocalizedString(min.toString(), "en"));
                params.add(minParam);
                result.fail().addMessage("{0} must be greater than or equal to {1}", "en", params);
            }
            if ((max = setting.getMaximumValue()) != null && floatValue > max.floatValue()) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(setting.getDisplayName());
                ArrayList<LocalizedString> maxParam = new ArrayList<LocalizedString>(1);
                maxParam.add(new LocalizedString(max.toString(), "en"));
                params.add(maxParam);
                result.fail().addMessage("{0} must be less than or equal to {1}", "en", params);
            }
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

