/*
 * Created on Feb 10, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;

/**
 * Marker interface indicating that the implementing interface is a source of the
 * {@link DocumentDetachEvent} event.
 * 
 * @author Vijay Silva
 */
public interface HasDocumentDetachHandlers extends HasHandlers {

	/**
	 * Adds a event handler for the {@link DocumentDetachEvent} event.
	 * 
	 * @param handler the handler
	 * @return the registration for the event
	 */
	HandlerRegistration addDocumentDetachHandler(DocumentDetachHandler handler);
}
