package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import java.util.List;

import com.google.gwt.user.client.ui.Widget;

/**
 * Provider for the expanding feature
 *
 * @author Daniel Silva
 *
 * @param <K> The parent record key
 * @param <R> The parent record
 * @param <CK> The child record key
 * @param <C> The child record
 */
public interface ExpandingProvider<K, R extends Record<K>, CK, C extends Record<CK>> {

	/**
	 * Get the widget to be set in the expanding panel
	 * 
	 * @param parentRecord The parent record
	 * @return The widget
	 */
	Widget getWidget(R parentRecord);

	/**
	 * Notifies that the parent selection state changed
	 * 
	 * @param parentRecord The parent record
	 * @param selected The selection state. True is selected, false otherwise
	 */
	void parentSelectionChanged(R parentRecord, boolean selected);
	
	/**
	 * Get the selected children records for the given parent record
	 * 
	 * @param parentRecord The parent record
	 * @return The selected children records
	 */
	List<C> getSelectedRecords( R parentRecord );
	
	/**
	 * Get the selected children records
	 * 
	 * @return The selected children records
	 */
	List<C> getSelectedRecords();
}
