/**
 * 
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;

/**
 * Build a Form Panel in order to allow to download the table content in an
 * excel format.<br>
 * <b>Note:</b> The table that is passed to the constructors needs to be 
 * initialized before the widget can use the same.
 * 
 * @author amit.r.seth
 * 
 */
public class ExportToExcelWidget extends FormPanel {

	private static final String DEFAULT_FILENAME = "export";
	
	/**
	 * 
	 */
	private static final String WIDGET_STYLE = "nwt-htmlTable-to-excel-exportWidget";
	private static final String PANEL_STYLE = "nwt-htmlTable-to-excel-panel";
	private static final String FORM_STYLE = "nwt-htmlTable-to-excel-form";
	
	/**
	 * 
	 */
	public ExportToExcelWidget() {
		super();
	}

	/**
	 * @param table
	 */
	public ExportToExcelWidget(final HTMLTable table) {
		this(table, DEFAULT_FILENAME);
	}

	/**
	 * Constructor
	 * 
	 * @param table
	 * @param labelText
	 * @param fileName
	 */
	public ExportToExcelWidget(HTMLTable table, String fileName) {
		this(table.getElement(), new PushButton(new ImageWidget("neptune_widget_toolkit/images/excel-icon-small.gif")), fileName);
	}

	/**
	 * @param table
	 */
	public ExportToExcelWidget(final Table<?, ?> table) {
		this(table, DEFAULT_FILENAME);
	}

	/**
	 * Constructor
	 * 
	 * @param table
	 * @param labelText
	 * @param fileName
	 */
	public ExportToExcelWidget(Table<?, ?> table, String fileName) {
		this(table.getTableListViewPanel().getTableColumnPanel().getElement(), new PushButton(new ImageWidget("neptune_widget_toolkit/images/excel-icon-small.gif")), fileName);
	}

	private ExportToExcelWidget(final Element tableElement, Widget exportWidget,
			String fileName) {
		this.setAction(GWT.getModuleBaseURL() + "neptune_widget_toolkit/jsps/tableToExcel.jsp");
		this.setMethod(FormPanel.METHOD_POST);
		this.addStyleName(FORM_STYLE);
		FlowPanel flowPanel = new FlowPanel();
		flowPanel.addStyleName(PANEL_STYLE);
		this.setWidget(flowPanel);
		final Hidden contentHidden = new Hidden("html");
		flowPanel.add(contentHidden);
		final Hidden fileNameHidden = new Hidden("fileName", fileName);
		flowPanel.add(fileNameHidden);
		flowPanel.add(exportWidget);
		exportWidget.addStyleName(WIDGET_STYLE);
		((HasClickHandlers) exportWidget).addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				// Copy only needed...
				contentHidden.setValue(tableElement.getString());
				submit();
			}
		});
	}

}
