package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Widget;

/*
 * When making multiple async calls, this busy indicator will continue to be rendered until all calls return back. 
 * 
 */
public class MultiTaskBusyIndicator {
	private final BusyIndicator busyIndicator;
	private int count = 0;

	public MultiTaskBusyIndicator() {
		this(null);
    }

	public MultiTaskBusyIndicator(Widget owningWidget) {
		busyIndicator = new BusyIndicator(owningWidget);
    }
	
	public synchronized void center() {
		if (count++ == 0)
			busyIndicator.center();
	}

	public synchronized void hide() {
		if (--count == 0)
			busyIndicator.hide();
	}

	public synchronized void hideAll() {
		count = 0;
		busyIndicator.hide();
	}
}
