package com.tandbergtv.neptune.widgettoolkit.client.application;

import java.io.Serializable;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Base class for all RPC exceptions. All exceptions that are to be thrown by the server and caught
 * on the client should extend this interface. Furthermore, the synchronous interface of the RPC
 * service should declare that each method within throws NeptuneException.
 * 
 * @author trybak
 */
public class NeptuneException extends Exception implements Serializable, IsSerializable {
	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a NeptuneException
	 */
	public NeptuneException() {
		super();
	}

	/**
	 * Constructs a NeptuneException with a message
	 * 
	 * @param message The detail message
	 */
	public NeptuneException(String message) {
		super(message);
	}
}
