package com.tandbergtv.neptune.widgettoolkit.client.event;

/**
 * Interface that should be used to publish a {@link NeptuneEvent} to the rest of Neptune
 * components.
 * 
 * @author trybak
 */
public interface EventSink {

	/**
	 * Fire the event to all registered listeners
	 * 
	 * @param <E> The event type
	 * @param event The event to fire
	 */
	public <E extends NeptuneEvent> void fireEvent(E event);
}
