/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.ejb;

import com.tandbergtv.neptune.settings.ejb.SettingsConfigurationLocator;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.Logger;

public class FilesystemSettingsConfigurationLoader
implements SettingsConfigurationLocator {
    private static final Logger logger = Logger.getLogger(FilesystemSettingsConfigurationLoader.class);
    private static final String SETTINGS_FOLDER_PATH = "Settings";
    private String confFolderLocation;

    public FilesystemSettingsConfigurationLoader(String configurationFolder) {
        this.confFolderLocation = configurationFolder;
    }

    @Override
    public List<URL> findSettingsConfigurations() {
        List<URL> settingsList = Collections.emptyList();
        File settingsFolder = null;
        try {
            settingsFolder = new File(this.confFolderLocation, SETTINGS_FOLDER_PATH);
            logger.debug((Object)("Retrieving neptuneSettings.xml file from settingsFodler and its subdiretories : " + settingsFolder.getAbsolutePath()));
            IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"neptuneSettings.xml", (IOCase)IOCase.INSENSITIVE);
            Collection settingsFile = FileUtils.listFiles((File)settingsFolder, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.TRUE);
            URL[] configs = FileUtils.toURLs((File[])settingsFile.toArray(new File[0]));
            settingsList = Arrays.asList(configs);
        }
        catch (Exception e) {
            logger.error((Object)("Error while loading components settings under: " + settingsFolder.getAbsolutePath()), (Throwable)e);
        }
        return settingsList;
    }
}

