/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.tandbergtv.neptune.alerts.service.IAlertsRecoveryService;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ejb.Local;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertsRecoveryService")
@Local(value={IAlertsRecoveryService.class})
public class AlertsRecoveryService
implements IAlertsRecoveryService {
    private static final Logger logger = Logger.getLogger(AlertsRecoveryService.class);
    private static final String DEFAULT_BASE_URL = "https://localhost:8443";
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    private int connTimeout = 30000;
    private int readTimeout = 60000;

    public String recover(String url, Map<String, String> parameters) {
        try {
            Future<String> returnStatus = this.executorService.submit(new FixRecoveryOptionTask(url, parameters));
            return returnStatus.get();
        }
        catch (Exception e) {
            logger.error((Object)("An error occured while executing the recover options for url: " + url + ", Error: " + e));
            return null;
        }
    }

    public void stop() {
        this.executorService.shutdownNow();
    }

    private final class FixRecoveryOptionTask
    implements Callable<String> {
        private String url;
        private Map<String, String> params;

        public FixRecoveryOptionTask(String url, Map<String, String> parameters) throws URISyntaxException {
            URI uri = new URI(url);
            this.url = uri.isAbsolute() ? url : AlertsRecoveryService.DEFAULT_BASE_URL + url;
            this.params = parameters;
        }

        @Override
        public String call() throws Exception {
            return this.sendRecoveryRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String sendRecoveryRequest() {
            logger.info((Object)"Executing FixRecoveryOptionTask -> sendRecoverRequest");
            HttpURLConnection conn = null;
            try {
                URL url = new URL(this.url);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setConnectTimeout(AlertsRecoveryService.this.connTimeout);
                conn.setReadTimeout(AlertsRecoveryService.this.readTimeout);
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString(this.params);
                OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
                osw.write(jsonString);
                osw.close();
                if (conn.getResponseCode() == 200) {
                    logger.info((Object)("Alert recovery URL: " + this.url + ", returned successfully."));
                } else {
                    logger.info((Object)("Alert recovery URL:" + this.url + " connection failed: HTTP error code : " + conn.getResponseCode() + " response message:" + conn.getResponseMessage()));
                }
                String string = Integer.toString(conn.getResponseCode());
                return string;
            }
            catch (SocketTimeoutException e) {
                logger.error((Object)(this.url + " connection timed out:" + e.getMessage()));
            }
            catch (Exception e) {
                logger.error((Object)("Error occurred sending recover request to url: " + this.url + ", parameters: " + this.params + ", Error: " + e));
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            return "";
        }
    }
}

