/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.networkmanagement.ejb;

import com.tandbergtv.neptune.networkelements.entity.CMSRedundancyStatus;
import com.tandbergtv.neptune.networkelements.entity.DbClusterInstance;
import com.tandbergtv.neptune.networkelements.entity.NetworkElement;
import com.tandbergtv.neptune.networkelements.entity.NetworkElementStatus;
import com.tandbergtv.neptune.networkmanagement.ejb.dao.NetworkElementsDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.log4j.Logger;

public class NetworkElementsManager {
    private static final String DB_CLUSTER_PRESENT_SQL_QUERY = "select value  from v$parameter where name = 'cluster_database'";
    private static final Logger logger = Logger.getLogger(NetworkElementsManager.class);
    private static final NetworkElementsManager instance = new NetworkElementsManager();
    protected long lastRefresh = 0L;
    public static final long DEFAULT_REFRESH_FREQUENCY = 60000L;
    protected long refreshFrequency = 0L;
    protected CMSRedundancyStatus redundancyStatus;
    private List<NetworkElement> clusterElements = new ArrayList<NetworkElement>();
    protected EntityManager entityManager;
    private Boolean isDbClusterPresent;

    private NetworkElementsManager() {
    }

    public static NetworkElementsManager getInstance() {
        return instance;
    }

    public CMSRedundancyStatus getRedundancyStatus() {
        this.fetchData();
        return this.redundancyStatus;
    }

    public List<NetworkElement> getClusterElementsStatus() {
        this.fetchData();
        return this.clusterElements;
    }

    protected List<NetworkElement> fetchDatabaseClusterInstances() {
        ArrayList<NetworkElement> databaseElements = new ArrayList<NetworkElement>();
        if (this.isDbClusterPresent()) {
            Query query = this.entityManager.createNamedQuery("DbClusterInstance.FindAll");
            List dbs = query.getResultList();
            if (this.clusterElements == null) {
                this.clusterElements = new ArrayList<NetworkElement>();
            }
            this.redundancyStatus.setDatabaseClusterStatus(NetworkElementStatus.ACTIVE);
            for (DbClusterInstance db : dbs) {
                NetworkElement ne = new NetworkElement();
                ne.setIp(db.getIpAddress());
                ne.setMode(db.getDatabaseRole());
                ne.setName(db.getDbInstanceName());
                ne.setStatus(NetworkElementStatus.valueOf((int)db.getDbStatus()));
                if (ne.getStatus().isFailed()) {
                    this.redundancyStatus.setDatabaseClusterStatus(NetworkElementStatus.FAILED);
                }
                databaseElements.add(ne);
            }
        } else {
            this.redundancyStatus.setDatabaseClusterStatus(NetworkElementStatus.ACTIVE);
        }
        return databaseElements;
    }

    private void logNodeStatusChange(List<NetworkElement> genericNodes, List<NetworkElement> databaseNodes) {
        if (logger.isInfoEnabled()) {
            NetworkElement previous;
            HashMap<String, NetworkElement> previousStatusMap = new HashMap<String, NetworkElement>(this.clusterElements.size());
            for (NetworkElement previous2 : this.clusterElements) {
                previousStatusMap.put(previous2.getName(), previous2);
            }
            for (NetworkElement current : genericNodes) {
                previous = (NetworkElement)previousStatusMap.get(current.getName());
                if (previous != null && previous.getStatus().equals((Object)current.getStatus())) continue;
                logger.info((Object)("Business continuance status change: node " + current.getName() + " status change to " + current.getStatus()));
            }
            for (NetworkElement current : databaseNodes) {
                previous = (NetworkElement)previousStatusMap.get(current.getName());
                if (previous == null || previous.getStatus().equals((Object)current.getStatus())) continue;
                String statusStr = "";
                if (current.getStatus().isActive()) {
                    statusStr = "RECOVERED";
                } else if (current.getStatus().isFailed()) {
                    statusStr = "FAILED";
                }
                logger.info((Object)("Business continuance status change: database cluster node " + current.getName() + " status change to " + statusStr));
            }
        }
    }

    private boolean isDbClusterPresent() {
        if (this.isDbClusterPresent == null) {
            Query nativeQuery = this.entityManager.createNativeQuery(DB_CLUSTER_PRESENT_SQL_QUERY);
            String result = (String)nativeQuery.getSingleResult();
            this.isDbClusterPresent = Boolean.valueOf(result);
            if (!this.isDbClusterPresent.booleanValue()) {
                logger.warn((Object)"Database cluster not present on current setup.");
            }
        }
        return this.isDbClusterPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchData() {
        if (System.currentTimeMillis() - this.lastRefresh > 60000L) {
            NetworkElementsManager networkElementsManager = this;
            synchronized (networkElementsManager) {
                if (System.currentTimeMillis() - this.lastRefresh > 60000L) {
                    this.refreshData();
                }
            }
        }
    }

    protected void refreshData() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        this.redundancyStatus = new CMSRedundancyStatus();
        this.redundancyStatus.setAppServerClusterStatus(dao.getRedundancyStatus());
        List<NetworkElement> updatedElements = dao.getClusterElementsStatus();
        List<NetworkElement> updatedDbElements = this.fetchDatabaseClusterInstances();
        this.logNodeStatusChange(updatedElements, updatedDbElements);
        updatedElements.addAll(updatedDbElements);
        this.clusterElements = updatedElements;
        this.lastRefresh = System.currentTimeMillis();
    }

    public Boolean failOverNow() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        return dao.failOverNow();
    }

    public void switchAutoFailOverPreference() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        dao.switchAutoFailOverPreference();
        this.refreshData();
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

