/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing.elim;

import com.tandbergtv.neptune.licensing.elim.CapacityKey;
import com.tandbergtv.neptune.licensing.elim.FeatureKey;
import com.tandbergtv.neptune.licensing.elim.Fingerprint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ELIMLicense {
    private Document doc;
    private String bodyStr = "";

    public ELIMLicense(File elimLic) throws ParserConfigurationException, IOException, SAXException {
        this.readLicenseXml(elimLic);
    }

    public String getVersion() {
        String version = null;
        String expr = "//@formatVersion";
        try {
            version = this.getValue(expr);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return version;
    }

    public int getSignatureType() {
        int sigType = -1;
        String expr = "//@signatureType";
        try {
            sigType = Integer.parseInt(this.getValue(expr));
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return sigType;
    }

    public String getProductType() {
        String productType = null;
        String expr = "//@productType";
        try {
            productType = this.getValue(expr);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return productType;
    }

    public String getPKISignature() {
        String pkiSig = null;
        String expr = "//PKIsignature";
        try {
            pkiSig = this.getValue(expr);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return pkiSig;
    }

    public String getProdCert() {
        String prodCert = null;
        String expr = "/licFile/certificatechain/prodcert";
        try {
            prodCert = this.getValue(expr);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return prodCert;
    }

    public String getCACert() {
        String caCert = null;
        String expr = "/licFile/certificatechain/cacert";
        try {
            caCert = this.getValue(expr);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return caCert;
    }

    public String getBody() {
        return this.bodyStr;
    }

    public List<CapacityKey> getCapacityKeys() {
        ArrayList<CapacityKey> capacityKeys = new ArrayList<CapacityKey>();
        String expr = "/licFile/body/SWLT/fingerprint/capacityKey";
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate(expr, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList stopDateList;
                Element curElem = (Element)nodeList.item(i);
                CapacityKey capacityKey = new CapacityKey();
                capacityKey.setId(curElem.getAttribute("id"));
                Element descElem = (Element)curElem.getElementsByTagName("description").item(0);
                capacityKey.setDesc(descElem.getTextContent());
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                NodeList startDateList = curElem.getElementsByTagName("start");
                if (startDateList != null && startDateList.getLength() > 0) {
                    Element startDateElem = (Element)startDateList.item(0);
                    try {
                        capacityKey.setStartDate(dateFormat.parse(startDateElem.getTextContent()));
                    }
                    catch (ParseException pe) {
                        System.err.println("Error parsing date: '" + startDateElem.getTextContent() + "': " + pe.getLocalizedMessage());
                    }
                }
                if ((stopDateList = curElem.getElementsByTagName("stop")) != null && stopDateList.getLength() > 0) {
                    Element stopDateElem = (Element)stopDateList.item(0);
                    try {
                        capacityKey.setStopDate(dateFormat.parse(stopDateElem.getTextContent()));
                    }
                    catch (ParseException pe) {
                        System.err.println("Error parsing date: '" + stopDateElem.getTextContent() + "': " + pe.getLocalizedMessage());
                    }
                } else {
                    NodeList noStopList = curElem.getElementsByTagName("noStop");
                    if (noStopList != null && noStopList.getLength() > 0) {
                        capacityKey.setNoStop(true);
                    }
                }
                Element capacityElem = (Element)curElem.getElementsByTagName("capacity").item(0);
                capacityKey.setCapacity(Long.parseLong(capacityElem.getTextContent()));
                Element hardLimitElem = (Element)curElem.getElementsByTagName("hardLimit").item(0);
                capacityKey.setHardLimit(Long.parseLong(hardLimitElem.getTextContent()));
                capacityKeys.add(capacityKey);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return capacityKeys;
    }

    public List<FeatureKey> getFeatureKeys() {
        ArrayList<FeatureKey> featureKeys = new ArrayList<FeatureKey>();
        String expr = "/licFile/body/SWLT/fingerprint/featureKey";
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate(expr, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList stopDateList;
                Element curElem = (Element)nodeList.item(i);
                FeatureKey featureKey = new FeatureKey();
                featureKey.setId(curElem.getAttribute("id"));
                Element descElem = (Element)curElem.getElementsByTagName("description").item(0);
                featureKey.setDesc(descElem.getTextContent());
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                NodeList startDateList = curElem.getElementsByTagName("start");
                if (startDateList != null && startDateList.getLength() > 0) {
                    Element startDateElem = (Element)startDateList.item(0);
                    try {
                        featureKey.setStartDate(dateFormat.parse(startDateElem.getTextContent()));
                    }
                    catch (ParseException pe) {
                        System.err.println("Error parsing date: '" + startDateElem.getTextContent() + "': " + pe.getLocalizedMessage());
                    }
                }
                if ((stopDateList = curElem.getElementsByTagName("stop")) != null && stopDateList.getLength() > 0) {
                    Element stopDateElem = (Element)stopDateList.item(0);
                    try {
                        featureKey.setStopDate(dateFormat.parse(stopDateElem.getTextContent()));
                    }
                    catch (ParseException pe) {
                        System.err.println("Error parsing date: '" + stopDateElem.getTextContent() + "': " + pe.getLocalizedMessage());
                    }
                } else {
                    NodeList noStopList = curElem.getElementsByTagName("noStop");
                    if (noStopList != null && noStopList.getLength() > 0) {
                        featureKey.setNoStop(true);
                    }
                }
                featureKeys.add(featureKey);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return featureKeys;
    }

    public Fingerprint getFingerprint() {
        Fingerprint fingerprint = null;
        String expr = "/licFile/body/SWLT/fingerprint";
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xPath.evaluate(expr, this.doc, XPathConstants.NODE);
            Element elem = (Element)node;
            String method = elem.getAttribute("method");
            String print = elem.getAttribute("print");
            fingerprint = new Fingerprint(Integer.parseInt(method), print);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return fingerprint;
    }

    public String getValue(String expr) throws XPathExpressionException {
        String value = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        value = xPath.evaluate(expr, this.doc);
        return value;
    }

    public void validate(String xsdPath) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new File(xsdPath));
        Validator validator = schema.newValidator();
        DOMSource xmlSource = new DOMSource(this.doc);
        validator.validate(xmlSource);
    }

    private void readLicenseXml(File file) throws IOException, ParserConfigurationException, SAXException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        int bodyStart = stringBuilder.indexOf("<body");
        this.bodyStr = stringBuilder.substring(bodyStart, stringBuilder.indexOf("</body>") + "</body>".length());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
        this.doc = docBuilder.parse(new InputSource(new StringReader(stringBuilder.toString())));
    }

    public static void main(String[] args) {
        try {
            ELIMLicense elimLicXml = new ELIMLicense(new File("resources/good_license.xml"));
            elimLicXml.validate("resources/LicFormat20_Schema_Rev_B.xsd");
            System.out.println("Version: " + elimLicXml.getVersion());
            System.out.println("PKISignature: " + elimLicXml.getPKISignature());
            System.out.println("prodcert: " + elimLicXml.getProdCert());
            System.out.println("cacert: " + elimLicXml.getCACert());
            System.out.println("body: " + elimLicXml.getBody());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

