/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.UUID;

public class FingerprintUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getPrint(File printFile) {
        UUID uuid = null;
        long chunkOne = -1L;
        long chunkTwo = -1L;
        long chunkThree = -1L;
        long chunkFour = -1L;
        long mask = -1L;
        long shift = -1L;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(printFile)));
            int i = 0;
            String curLine = null;
            while ((curLine = reader.readLine()) != null) {
                switch (++i) {
                    case 3: {
                        chunkThree = Long.parseLong(curLine);
                        break;
                    }
                    case 4: {
                        mask = Long.parseLong(curLine);
                        break;
                    }
                    case 6: {
                        chunkOne = Long.parseLong(curLine);
                        break;
                    }
                    case 10: {
                        chunkTwo = Long.parseLong(curLine);
                        break;
                    }
                    case 13: {
                        chunkFour = Long.parseLong(curLine);
                        break;
                    }
                    case 15: {
                        shift = Long.parseLong(curLine) % 32L;
                    }
                }
            }
            String hex4 = String.format("%08X", this.rotl(chunkFour, shift) ^ mask);
            String hex3 = String.format("%08X", this.rotl(chunkThree, shift) ^ mask);
            String hex2 = String.format("%08X", this.rotl(chunkTwo, shift) ^ mask);
            String hex1 = String.format("%08X", this.rotl(chunkOne, shift) ^ mask);
            uuid = UUID.fromString(this.formatUUID(hex4 + hex3 + hex2 + hex1));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        return uuid;
    }

    private long rotl(long orig, long shift) {
        return (orig << (int)shift | orig >> (int)(32L - shift)) & Long.parseLong("ffffffff", 16);
    }

    private String formatUUID(String uuid) {
        return uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
    }
}

