/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.componentmgr.ejb;

import com.ericsson.neptune.componentmgr.service.IComponentManager;
import com.tandbergtv.neptune.realm.persist.Component;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;

public class ComponentValidator {
    private final IComponentManager componentManager;
    private static final int NAME_MAX_LENGTH = 100;
    private static final int URL_MAX_LENGTH = 200;

    public ComponentValidator(IComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public void validateComponent(Component component) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        this.validateName(component, validationMessages);
        this.validateBaseURL(component, validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateName(Component component, List<String> messages) {
        String name = component.getName();
        if (this.isBlank(name)) {
            messages.add("Component Name is required.");
            return;
        }
        if (name.length() > 100) {
            messages.add("Component Name exceeds maximum length of 100");
            return;
        }
        Component existingComponent = this.componentManager.getComponent(name);
        if (existingComponent != null && !existingComponent.equals((Object)component)) {
            messages.add("Component Name already exists.");
            return;
        }
    }

    private void validateBaseURL(Component component, List<String> messages) {
        String baseURL = component.getBaseURL();
        if (this.isBlank(baseURL)) {
            messages.add("Component URL is required.");
            return;
        }
        if (baseURL.length() > 200) {
            messages.add("Component URL exceeds maximum length of 200");
            return;
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

