/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.tandbergtv.neptune.alerts.rest.client.AlertsConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

@MessageDriven(name="AlertCmdHandlerMDBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/AlertCmdQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class AlertCmdMDBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(AlertCmdMDBean.class);
    @Resource
    private MessageDrivenContext context;

    public void onMessage(Message msg) {
        try {
            String url = msg.getStringProperty("url");
            String user = msg.getStringProperty("user");
            String pwd = msg.getStringProperty("pwd");
            Destination returnDestination = msg.getJMSReplyTo();
            String correlationId = msg.getJMSMessageID();
            AlertsConsumer compAlerts = new AlertsConsumer(url, user, pwd);
            String res = compAlerts.getJsonSummary();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.context.lookup("ConnectionFactory");
            QueueConnection queueConnection = queueFactory.createQueueConnection();
            QueueSession replySession = queueConnection.createQueueSession(false, 1);
            if (returnDestination != null) {
                MessageProducer messageProducer = replySession.createProducer(returnDestination);
                TextMessage returnMessage = replySession.createTextMessage(res);
                returnMessage.setJMSCorrelationID(correlationId);
                messageProducer.send((Message)returnMessage);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private int getMessageSizeInBytes(Message message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(message);
        oos.close();
        return baos.size();
    }
}

