/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.AggregationJob;
import com.ericsson.neptune.alerts.entity.Alert;
import com.ericsson.neptune.alerts.entity.AlertsSummary;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;
import javax.ejb.Local;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertAggregationService")
@Local(value={IAlertsAggregationService.class})
public class AlertsAggregationService
implements IAlertsAggregationService {
    private static final String PROPERTIES_FILE = "conf/neptune/alerts.properties";
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    int waitTime = 30000;
    int pollInterval = 30000;
    @EJB
    private ISettingsService settingsService;
    List<Alert> alerts;
    private static final Logger log = Logger.getLogger(AlertsAggregationService.class);

    public void start() throws Exception {
        Properties props = AlertsAggregationService.readInitProperties();
        if (props == null || props.isEmpty()) {
            log.info((Object)"... Failed to start alert aggregation service-alert properties not set");
            return;
        }
        this.waitTime = Integer.parseInt(props.get("wait.time").toString());
        this.pollInterval = Integer.parseInt(props.get("poll.interval").toString());
        if (this.pollInterval == 0) {
            return;
        }
        JobDetail job = new JobDetail();
        job.setName("Alerts Aggregation");
        job.setJobClass(AggregationJob.class);
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setName("Alerts Update");
        trigger.setStartTime(new Date(System.currentTimeMillis() + (long)this.waitTime));
        trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
        trigger.setRepeatInterval((long)this.pollInterval);
        Scheduler scheduler = new StdSchedulerFactory().getScheduler();
        scheduler.start();
        scheduler.scheduleJob(job, (Trigger)trigger);
        log.info((Object)("... Alert aggregation service scheduled every " + this.pollInterval / 1000 + " secs"));
    }

    public synchronized AlertsSummary getSummary() {
        AlertsSummary sum = new AlertsSummary();
        if (this.alerts == null || this.alerts.isEmpty()) {
            return sum;
        }
        int errors = 0;
        int warnings = 0;
        int informationals = 0;
        for (Alert alert : this.alerts) {
            if (alert.getSeverity() == SeverityType.Error) {
                ++errors;
                continue;
            }
            if (alert.getSeverity() == SeverityType.Warning) {
                ++warnings;
                continue;
            }
            if (alert.getSeverity() != SeverityType.Informational) continue;
            ++informationals;
        }
        sum.setTotalErrors(Integer.valueOf(errors));
        sum.setTotalWarnings(Integer.valueOf(warnings));
        sum.setTotalInformationals(Integer.valueOf(informationals));
        return sum;
    }

    public synchronized List<Alert> getAlerts() {
        return this.alerts;
    }

    public synchronized void setAlerts(List<Alert> alerts) {
        this.alerts = new ArrayList<Alert>();
        this.alerts.addAll(alerts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readInitProperties() {
        Properties props = new Properties();
        InputStream is = null;
        String optFolder = System.getProperty(INSTALL_FOLDER_PROPERTY);
        if (optFolder == null) {
            optFolder = "/opt/tandbergtv/cms";
        }
        try {
            File f = new File(optFolder, PROPERTIES_FILE);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (IOException e) {
            log.debug((Object)"Can not load properties from conf/neptune/alerts.properties", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Can not close input stream for properties file conf/neptune/alerts.properties", (Throwable)e);
                }
            }
        }
        return props;
    }
}

