/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.AlertsAggregationService;
import com.ericsson.neptune.alerts.entity.Alert;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.type.JavaType;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class AggregationJob
implements Job {
    private static final Logger logger = Logger.getLogger(AggregationJob.class);
    static String alertQueueName = "queue/AlertCmdQueue";
    static int responseTimeout = 10000;
    IAlertsAggregationService alertsAggregationService = (IAlertsAggregationService)InjectionUtil.injectInstance((String)"cms/AlertsAggregationService/local", IAlertsAggregationService.class);

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        this.pollAlertProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAlertProviders() {
        InitialContext context = null;
        QueueSession queueSession = null;
        try {
            Message response;
            context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("java:/JmsXA");
            QueueConnection queueConnection = queueFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(true, 0);
            Queue queue = (Queue)context.lookup(alertQueueName);
            QueueSender queueSender = queueSession.createSender(queue);
            TemporaryQueue replyQueue = queueSession.createTemporaryQueue();
            Properties props = AlertsAggregationService.readInitProperties();
            String url = null;
            String name = null;
            String pwd = null;
            if (props == null) {
                return;
            }
            url = props.get("test.url").toString();
            name = props.get("test.user").toString();
            pwd = props.get("test.pwd").toString();
            int num_providers = Integer.parseInt(props.get("test.provider.num").toString());
            for (int i = 0; i < num_providers; ++i) {
                ObjectMessage message = queueSession.createObjectMessage();
                message.setJMSReplyTo((Destination)replyQueue);
                message.setStringProperty("url", url);
                message.setStringProperty("user", name);
                message.setStringProperty("pwd", pwd);
                queueSender.send(queue, (Message)message);
            }
            queueConnection.start();
            MessageConsumer consumer = queueSession.createConsumer((Destination)replyQueue);
            ArrayList<Alert> allAlerts = new ArrayList<Alert>();
            while ((response = consumer.receive((long)responseTimeout)) != null) {
                TextMessage res = (TextMessage)response;
                logger.debug((Object)("Recv Json String from MDB:" + res.getText()));
                List<Alert> componentAlertList = AggregationJob.getAlertsFromJsonString(res.getText());
                logger.debug((Object)("List of Alerts: " + AggregationJob.getAlertsFromJsonString(res.getText()).toString()));
                allAlerts.addAll(componentAlertList);
            }
            logger.debug((Object)("Total # of alerts from polled alert providers: " + allAlerts.size()));
            this.alertsAggregationService.setAlerts(allAlerts);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending the event", (Throwable)e);
        }
        finally {
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close the JMS session and context", (Throwable)e);
            }
        }
    }

    void setProperties(Message message, Queue replyQueue, String url, String name, String pwd) throws JMSException {
        message.setJMSReplyTo((Destination)replyQueue);
        message.setStringProperty("url", url);
        message.setStringProperty("user", name);
        message.setStringProperty("pwd", pwd);
    }

    public static List<Alert> getAlertsFromJsonString(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Class<?> clz = Class.forName(Alert.class.getName());
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clz);
        List alerts = (List)mapper.readValue(jsonString, (JavaType)type);
        return alerts;
    }
}

