/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.JobScheduler;
import com.ericsson.neptune.alerts.entity.Alert;
import com.ericsson.neptune.alerts.entity.AlertsSummary;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.type.JavaType;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertAggregationService")
@Local(value={IAlertsAggregationService.class})
public class AlertsAggregationService
implements IAlertsAggregationService {
    static String alertQueueName = "queue/AlertCmdQueue";
    private static final String PROPERTIES_FILE = "conf/neptune/alerts.properties";
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final Logger logger = Logger.getLogger(AlertsAggregationService.class);
    int waitTime = 30000;
    int pollInterval = 30000;
    int responseTimeout = 10000;
    @EJB
    private ISettingsService settingsService;
    List<Alert> alerts;

    public void start() throws Exception {
        Properties props = AlertsAggregationService.readInitProperties();
        if (props == null || props.isEmpty()) {
            logger.info((Object)"... Failed to start alert aggregation service-alert properties not set");
            return;
        }
        this.waitTime = Integer.parseInt(props.get("wait.time").toString());
        this.pollInterval = Integer.parseInt(props.get("poll.interval").toString());
        if (this.pollInterval == 0) {
            return;
        }
        JobScheduler scheduler = new JobScheduler(1);
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                AlertsAggregationService.this.pollAlertProviders();
            }
        }, this.waitTime, this.pollInterval);
        logger.info((Object)("... Alert aggregation job scheduled every " + this.pollInterval / 1000 + " secs"));
    }

    public synchronized AlertsSummary getSummary() {
        AlertsSummary sum = new AlertsSummary();
        if (this.alerts == null || this.alerts.isEmpty()) {
            return sum;
        }
        int errors = 0;
        int warnings = 0;
        int informationals = 0;
        for (Alert alert : this.alerts) {
            if (alert.getSeverity() == SeverityType.Error) {
                ++errors;
                continue;
            }
            if (alert.getSeverity() == SeverityType.Warning) {
                ++warnings;
                continue;
            }
            if (alert.getSeverity() != SeverityType.Informational) continue;
            ++informationals;
        }
        sum.setTotalErrors(Integer.valueOf(errors));
        sum.setTotalWarnings(Integer.valueOf(warnings));
        sum.setTotalInformationals(Integer.valueOf(informationals));
        return sum;
    }

    public synchronized List<Alert> getAlerts() {
        return this.alerts;
    }

    public synchronized void setAlerts(List<Alert> alerts) {
        this.alerts = new ArrayList<Alert>();
        this.alerts.addAll(alerts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAlertProviders() {
        InitialContext context = null;
        QueueSession queueSession = null;
        try {
            Message response;
            context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("java:/JmsXA");
            QueueConnection queueConnection = queueFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(true, 0);
            Queue queue = (Queue)context.lookup(alertQueueName);
            QueueSender queueSender = queueSession.createSender(queue);
            queueSender.setDeliveryMode(1);
            TemporaryQueue replyQueue = queueSession.createTemporaryQueue();
            Properties props = AlertsAggregationService.readInitProperties();
            String url = null;
            String name = null;
            String pwd = null;
            if (props == null) {
                return;
            }
            url = props.get("test.url").toString();
            name = props.get("test.user").toString();
            pwd = props.get("test.pwd").toString();
            int num_providers = Integer.parseInt(props.get("test.provider.num").toString());
            for (int i = 0; i < num_providers; ++i) {
                ObjectMessage message = queueSession.createObjectMessage();
                message.setJMSReplyTo((Destination)replyQueue);
                message.setStringProperty("url", url);
                message.setStringProperty("user", name);
                message.setStringProperty("pwd", pwd);
                queueSender.send(queue, (Message)message);
            }
            queueConnection.start();
            MessageConsumer consumer = queueSession.createConsumer((Destination)replyQueue);
            ArrayList<Alert> allAlerts = new ArrayList<Alert>();
            while ((response = consumer.receive((long)this.responseTimeout)) != null) {
                TextMessage res = (TextMessage)response;
                logger.debug((Object)("Recv Json String from MDB:" + res.getText()));
                String jSonString = res.getText();
                if (jSonString == null || jSonString.isEmpty()) continue;
                List<Alert> componentAlertList = this.getAlertsFromJsonString(jSonString);
                logger.debug((Object)("List of Alerts: " + this.getAlertsFromJsonString(jSonString).toString()));
                allAlerts.addAll(componentAlertList);
            }
            logger.debug((Object)("Total # of alerts from polled alert providers: " + allAlerts.size()));
            this.setAlerts(allAlerts);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending the event", (Throwable)e);
        }
        finally {
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close the JMS session and context", (Throwable)e);
            }
        }
    }

    private List<Alert> getAlertsFromJsonString(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Class<?> clz = Class.forName(Alert.class.getName());
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clz);
        List alerts = (List)mapper.readValue(jsonString, (JavaType)type);
        return alerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readInitProperties() {
        Properties props = new Properties();
        InputStream is = null;
        String optFolder = System.getProperty(INSTALL_FOLDER_PROPERTY);
        if (optFolder == null) {
            optFolder = "/opt/tandbergtv/cms";
        }
        try {
            File f = new File(optFolder, PROPERTIES_FILE);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (IOException e) {
            logger.debug((Object)"Can not load properties from conf/neptune/alerts.properties", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Can not close input stream for properties file conf/neptune/alerts.properties", (Throwable)e);
                }
            }
        }
        return props;
    }
}

