/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.tandbergtv.neptune.alerts.rest.client.RestClient;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

@MessageDriven(name="AlertCmdHandlerMDBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/AlertCmdQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class AlertCmdMDBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(AlertCmdMDBean.class);
    @Resource
    private MessageDrivenContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        QueueSession replySession = null;
        try {
            String url = msg.getStringProperty("url");
            String user = msg.getStringProperty("user");
            String pwd = msg.getStringProperty("pwd");
            Destination returnDestination = msg.getJMSReplyTo();
            String correlationId = msg.getJMSMessageID();
            RestClient compAlerts = new RestClient(user, pwd);
            String res = compAlerts.getJsonAlerts(url);
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.context.lookup("ConnectionFactory");
            QueueConnection queueConnection = queueFactory.createQueueConnection();
            replySession = queueConnection.createQueueSession(false, 1);
            if (returnDestination != null) {
                MessageProducer messageProducer = replySession.createProducer(returnDestination);
                messageProducer.setDeliveryMode(1);
                TextMessage returnMessage = replySession.createTextMessage(res);
                returnMessage.setJMSCorrelationID(correlationId);
                messageProducer.send((Message)returnMessage);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (replySession != null) {
                    replySession.close();
                }
            }
            catch (JMSException e) {
                logger.error((Object)"Failed to close the JMS session", (Throwable)e);
            }
        }
    }
}

