/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.Aggregator;
import com.ericsson.neptune.alerts.ejb.JobScheduler;
import com.ericsson.neptune.alerts.entity.Alert;
import com.ericsson.neptune.alerts.entity.AlertsSummary;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;
import javax.ejb.Local;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertAggregationService")
@Local(value={IAlertsAggregationService.class})
public class AlertsAggregationService
implements IAlertsAggregationService {
    private static final Logger logger = Logger.getLogger(AlertsAggregationService.class);
    int waitTime = 30000;
    int pollInterval = 30000;
    @EJB
    private ISettingsService settingsService;
    List<Alert> alerts;

    public void start() throws Exception {
        Properties props = Aggregator.readInitProperties();
        if (props == null || props.isEmpty()) {
            logger.info((Object)"... Failed to start alert aggregation service-alert properties not set");
            return;
        }
        this.waitTime = Integer.parseInt(props.get("wait.time").toString());
        this.pollInterval = Integer.parseInt(props.get("poll.interval").toString());
        if (this.pollInterval == 0) {
            return;
        }
        JobScheduler scheduler = new JobScheduler(1);
        scheduler.schedule(new Aggregator(), this.waitTime, this.pollInterval);
        logger.info((Object)("... Alert aggregation job scheduled every " + this.pollInterval / 1000 + " secs"));
    }

    public synchronized AlertsSummary getSummary() {
        AlertsSummary sum = new AlertsSummary();
        if (this.alerts == null || this.alerts.isEmpty()) {
            return sum;
        }
        int errors = 0;
        int warnings = 0;
        int informationals = 0;
        for (Alert alert : this.alerts) {
            if (alert.getSeverity() == SeverityType.Error) {
                ++errors;
                continue;
            }
            if (alert.getSeverity() == SeverityType.Warning) {
                ++warnings;
                continue;
            }
            if (alert.getSeverity() != SeverityType.Informational) continue;
            ++informationals;
        }
        sum.setTotalErrors(Integer.valueOf(errors));
        sum.setTotalWarnings(Integer.valueOf(warnings));
        sum.setTotalInformationals(Integer.valueOf(informationals));
        return sum;
    }

    public synchronized List<Alert> getAlerts() {
        return this.alerts;
    }

    public synchronized void setAlerts(List<Alert> alerts) {
        this.alerts = new ArrayList<Alert>();
        this.alerts.addAll(alerts);
    }
}

