/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.Aggregator;
import com.ericsson.neptune.alerts.ejb.JobScheduler;
import com.ericsson.neptune.alerts.entity.Alert;
import com.ericsson.neptune.alerts.entity.AlertsSummary;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertAggregationService")
@Local(value={IAlertsAggregationService.class})
public class AlertsAggregationService
implements IAlertsAggregationService {
    ISettingsService configService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);
    private static final Logger logger = Logger.getLogger(AlertsAggregationService.class);
    int waitTime = 0;
    int pollInterval = 0;
    @EJB
    private ISettingsService settingsService;
    List<Alert> alerts;

    public void start() throws Exception {
        boolean check = true;
        int count = 10;
        do {
            try {
                this.waitTime = Integer.parseInt((String)this.configService.getProperties("com.ericsson.cms.neptune.uialerts.timeinterval").get("wait_time"));
                this.pollInterval = Integer.parseInt((String)this.configService.getProperties("com.ericsson.cms.neptune.uialerts.timeinterval").get("poll_interval"));
                check = false;
            }
            catch (Exception e) {
                Thread.sleep(1000L);
                check = true;
                --count;
            }
        } while (check && count > 0);
        if (this.pollInterval == 0) {
            return;
        }
        JobScheduler scheduler = new JobScheduler(1);
        scheduler.schedule(new Aggregator(), this.waitTime, this.pollInterval);
        logger.info((Object)("... Alert aggregation job scheduled every " + this.pollInterval / 1000 + " secs"));
    }

    public synchronized AlertsSummary getSummary() {
        AlertsSummary sum = new AlertsSummary();
        if (this.alerts == null || this.alerts.isEmpty()) {
            return sum;
        }
        int errors = 0;
        int warnings = 0;
        int informationals = 0;
        for (Alert alert : this.alerts) {
            if (alert.getSeverity() == SeverityType.Error) {
                ++errors;
                continue;
            }
            if (alert.getSeverity() == SeverityType.Warning) {
                ++warnings;
                continue;
            }
            if (alert.getSeverity() != SeverityType.Informational) continue;
            ++informationals;
        }
        sum.setTotalErrors(Integer.valueOf(errors));
        sum.setTotalWarnings(Integer.valueOf(warnings));
        sum.setTotalInformationals(Integer.valueOf(informationals));
        return sum;
    }

    public synchronized List<Alert> getAlerts() {
        return this.alerts;
    }

    public synchronized void setAlerts(List<Alert> alerts) {
        this.alerts = new ArrayList<Alert>();
        this.alerts.addAll(alerts);
    }
}

