/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.tandbergtv.neptune.alerts.service.IAlertsRecoveryService;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ejb.Local;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertsRecoveryService")
@Local(value={IAlertsRecoveryService.class})
public class AlertsRecoveryService
implements IAlertsRecoveryService {
    private static final Logger logger = Logger.getLogger(AlertsRecoveryService.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    private int connTimeout = 2000;
    private int readTimeout = 10000;

    public String recover(String url, Map<String, String> parameters) {
        logger.info((Object)("Called recover with URL:" + url));
        try {
            Future<String> returnStatus = this.executorService.submit(new FixRecoveryOptionTask(url, parameters));
            logger.info((Object)returnStatus.get());
            return returnStatus.get();
        }
        catch (Exception e) {
            logger.error((Object)("An error occured while executing the recover options for url: " + url + ", message: " + e.getMessage()));
            return null;
        }
    }

    public void stop() {
        this.executorService.shutdownNow();
    }

    private final class FixRecoveryOptionTask
    implements Callable<String> {
        private String url;

        public FixRecoveryOptionTask(String url, Map<String, String> parameters) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(url);
            boolean isStart = true;
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, String> param : parameters.entrySet()) {
                    if (isStart) {
                        urlBuilder.append("?");
                        isStart = false;
                    } else {
                        urlBuilder.append("&");
                    }
                    urlBuilder.append(param.getKey()).append("=").append(param.getValue());
                }
            }
            this.url = urlBuilder.toString();
            logger.info((Object)("Creating new FixRecoveryOptionTask with url: " + this.url));
        }

        @Override
        public String call() throws Exception {
            return this.sendRecoveryRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String sendRecoveryRequest() {
            logger.info((Object)"Executing FixRecoveryOptionTask -> sendRecoverRequest");
            HttpURLConnection conn = null;
            try {
                URL url = new URL(this.url);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setConnectTimeout(AlertsRecoveryService.this.connTimeout);
                conn.setReadTimeout(AlertsRecoveryService.this.readTimeout);
                if (conn.getResponseCode() == 200) {
                    logger.info((Object)("Alert recovery URL: " + this.url + ", returned successfully."));
                } else {
                    logger.info((Object)("Alert recovery URL:" + this.url + " connection failed: HTTP error code : " + conn.getResponseCode() + " response message:" + conn.getResponseMessage()));
                }
                String string = Integer.toString(conn.getResponseCode());
                return string;
            }
            catch (SocketTimeoutException e) {
                logger.info((Object)(this.url + " connection timed out:" + e.getMessage()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            return null;
        }
    }
}

