package com.tandbergtv.neptune.ui.portalpage.client.ui;

import org.gwtportlets.portlet.client.AbstractWidgetFactory;
import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.WidgetInfo;
import org.gwtportlets.portlet.client.layout.Container;
import org.gwtportlets.portlet.client.layout.LayoutEvent;
import org.gwtportlets.portlet.client.layout.RowLayout;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshHandler;

/**
 * Gadget with a com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet
 */
@SuppressWarnings("unchecked")
public class NeptuneGadget extends Gadget {
	
	private PortletFactory portletFactory;
	private Portlet portlet = null;
	private int lastPortletHeight = 0;
	private HandlerRegistration refreshHandlerRegistration = null;
	private DockLayoutPanel mainContainer;
	private FlexTable contentContainer;

	public NeptuneGadget() {
		super();
		mainContainer = new DockLayoutPanel(Unit.EM);
		contentContainer = new FlexTable();
		contentContainer.setSize("100%", "100%");
		contentContainer.setBorderWidth(0);
		mainContainer.add(contentContainer);
		super.add(mainContainer);
	}
	
	public NeptuneGadget(PortletFactory portletFactory) {
		this();
		setPortletFactory(portletFactory);
	}
	
	public void setPortletFactory(PortletFactory portletFactory) {
		this.portletFactory = portletFactory;
		setPortlet();
	}
	
	private void setPortlet() {
		lastPortletHeight = 0;
		if (portlet == portletFactory.getInstance()) {
			return;
		}
		if (portlet != null) {
			if (refreshHandlerRegistration != null) {
				refreshHandlerRegistration.removeHandler();
			}
			contentContainer.remove(portlet);
		}
		portlet = portletFactory.getInstance();
		refreshHandlerRegistration = portlet.addRefreshHandler(new EventHandler());
    	super.setPortletId(portlet.getPortletId());
    	super.setPortletTitle(portlet.getDisplayName());
		contentContainer.setWidget(0, 0, portlet);
		contentContainer.getFlexCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_TOP);
		contentContainer.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
	}
	
   @Override
    public void restore() {
   		super.restore();
   		refreshHeight();
    }
    
	@Override
	public String getComponent() {
		return portletFactory.getComponent().getDisplayName();
	}

	@Override
	public void setHeight(int height) {
    	if (isMinimized) {
    		return;
    	}
    	
        if (height >= 0 && height != lastPortletHeight) {
        	int totalHeight = height + TITLE_HEIGHT;
	        Container container = (Container) getParent();
	        if (container != null) {
		        container.setLayoutConstraints(this, new RowLayout.Constraints(totalHeight));
		        container.layout();
	        }
        	lastPortletHeight = height;
        }
	}
	
	private void refreshHeight() {
		setHeight(portlet.getBody().getComputedHeight());
	}
	
	private void refreshPortlet() {
		if (portlet != null) {
	    	super.setPortletTitle(portlet.getDisplayName());
	    	refreshHeight();
	    	update();
		}
	}
	
	@Override
	public void refresh() {
		super.refresh();
		refreshPortlet();
	}

	@Override
	public void onAttach() {
		super.onAttach();
		if (portlet != null) {
			portlet.fireEvent(new DocumentAttachEvent());
		}
	}
	
	@Override
	public void onDetach() {
		super.onDetach();
		if (portlet != null) {
			portlet.fireEvent(new DocumentDetachEvent());
		}
	}
	
	@Override
	public void onLayoutUpdated(LayoutEvent event) {
		if (isAttached()) {
			Scheduler.get().scheduleDeferred(new Command() {
				@Override
				public void execute() {
					refreshHeight();
				}
			});
		}
	}
	
    public WidgetFactory<NeptuneGadget> createWidgetFactory() {
        return new Factory(this);
    }

    @WidgetInfo(description = "Gadget displaying Portlet in TitlePanel")
    public static class Factory extends AbstractWidgetFactory<NeptuneGadget> {

		private static final long serialVersionUID = 1L;
		private PortletFactory portletFactory;

		public Factory() {
        }

        public Factory(NeptuneGadget gadget) {
            super(gadget);
            portletFactory = gadget.portletFactory;
        }

        @Override
        public void refresh(NeptuneGadget gadget) {
            gadget.setPortletFactory(portletFactory);
            super.refresh(gadget);
        }

        @Override
        public NeptuneGadget createWidget() {
            return new NeptuneGadget();
        }
    }
    
	/*
	 * Event Handling
	 */
	private final class EventHandler implements RefreshHandler {
		@Override
		public void onRefresh(RefreshEvent event) {
			Scheduler.get().scheduleDeferred(new Command() {
				@Override
				public void execute() {
					refreshPortlet();
				}
			});
		}
	}

}
