package com.tandbergtv.neptune.ui.portalpage.client.ui;

import org.gwtportlets.portlet.client.layout.LayoutEvent;
import org.gwtportlets.portlet.client.layout.LayoutHandler;
import org.gwtportlets.portlet.client.ui.LayoutPanel;
import org.gwtportlets.portlet.client.ui.Portlet;
import org.gwtportlets.portlet.client.ui.TitlePanel;
import org.gwtportlets.portlet.client.ui.ToolButton;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.neptune.ui.portalpage.client.PortletConfig;
import com.tandbergtv.neptune.ui.portalpage.client.HtmlPortletConfig;
import com.tandbergtv.neptune.ui.portalpage.client.NeptunePortletConfig;

/**
 * Displays Widget in a TitlePanel
 */
@SuppressWarnings("unchecked")
public abstract class Gadget extends TitlePanel implements HasGadgetCloseHandlers, LayoutHandler {

	public static final int MINIMIZE = 8;
	
	protected boolean isMinimized = false;
	protected boolean isMaximized = false;   // unlike TitlePanel.isMaximized(), this is true if max at any level

	protected static final int TITLE_HEIGHT = 32;
	private static final int DEFAULT_HEIGHT = TITLE_HEIGHT+50;   // in pixels, for gadgets that don't set height
	
	protected int defaultHeight = DEFAULT_HEIGHT;
	private String portletId = "";
	
	public Gadget() {
		super();
		setStyleName("gadget");
	}
	
	public static Gadget createGadget(PortletConfig config) {
		if (config instanceof HtmlPortletConfig) {
			return new HtmlGadget(config.getComponent(), config.getPortletId(), config.getTitle(), ((HtmlPortletConfig) config).getUrl());
		} else if (config instanceof NeptunePortletConfig) {
			return new NeptuneGadget(((NeptunePortletConfig) config).getPortletFactory());
		}
		return null;
	}
	
    public void setPortletTitle(String title) {
		super.setTitleText(title);
		super.setTitleTextAuto(false);    	
    }
    
    public String getPortletId() {
    	return portletId;
    }
    
    public void setPortletId(String portletId) {
    	this.portletId = portletId;
    }
    
    public abstract String getComponent();
    
    public abstract void setHeight(int height);
    
    public int getDefaultHeight() {
    	return defaultHeight;
    }

    @Override
    protected void addRightButtons(int flags) {
        if ((flags & Portlet.REFRESH) != 0) {
            addTitleButton(createRefresh());
        }
        if ((flags & Portlet.CONFIGURE) != 0) {
            addTitleButton(createConfigure());
        }
        if (!isMaximized) {
			if (!isMinimized) {
				addTitleButton(createMinimize());
			} else {
	        	addTitleButton(createRestore());
			}
        }
        if ((flags & Portlet.MAXIMIZE) != 0) {
            if (isMaximized) {
                addTitleButton(createRestore());
            } else {
                addTitleButton(createMaximize());
            }
        }
        addTitleButton(createClose());
    }
        
    protected ToolButton createMinimize() {
        return new ToolButton(ToolButton.MINIMIZE, "Minimize", new ClickHandler() {
            public void onClick(ClickEvent event) {
                minimize();
            }
        });
    }

    protected ToolButton createClose() {
        return new ToolButton(ToolButton.CLOSE, "Close", new ClickHandler() {
            public void onClick(ClickEvent event) {
                close();
            }
        });
    }
    
    @Override
    public void restore() {
    	isMinimized = false;
    	isMaximized = false;
    	if (!isMaximized()) {
    		update();
    	} else {
    		super.restore();
    	}
    }
    
    @Override
    public void maximize() {
    	isMaximized = true;
    	super.maximize();
    }
    
    public void minimize() {
    	setHeight(0);
    	isMinimized = true;
    	update();
    }
    
    public void close() {
    	LayoutPanel parent = (LayoutPanel) getParent();
    	parent.remove(this);
    	parent.layout();
    	GadgetCloseEvent.fire(this);
    }

	public HandlerRegistration addGadgetCloseHandler(GadgetCloseHandler handler) {
		return addHandler(handler, GadgetCloseEvent.TYPE);
	}
    
    @Override
    protected int getEnhancedFlags() {
        return (super.getEnhancedFlags() | (isMinimized ? 0 : MINIMIZE));
    }
    
	@Override
	public void onLayoutUpdated(LayoutEvent event) {
	}

}
