package com.tandbergtv.neptune.ui.componentmgr.client.tab.component.view;

import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model.UiComponent;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model.UiComponentKey;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record for the component
 * 
 */
final class ComponentRecord implements Record<UiComponentKey> {

	/* The component managed by the record */
	private final UiComponent component;

	/**
	 * Constructor
	 * 
	 * @param component The component
	 */
	public ComponentRecord(UiComponent component) {
		this.component = component;
	}

	/**
	 * Get the key for the component
	 * 
	 * @return The component key
	 */
	@Override
	public UiComponentKey getKey() {
		return component.getKey();
	}

	/**
	 * Get the component
	 * 
	 * @return The component
	 */
	public UiComponent getComponent() {
		return this.component;
	}
}
