/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ldap;

import com.tandbergtv.neptune.usermgmt.external.ldap.LdapConfigurationException;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapConfiguration;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

class LdapConfigurationManager {
    private static final Logger logger = Logger.getLogger(LdapConfigurationManager.class);
    private final File configurationFile;
    private final LdapConfiguration configuration;

    public LdapConfigurationManager(File configurationFile) {
        this.configurationFile = configurationFile;
        this.configuration = this.loadConfiguration();
    }

    public LdapConfiguration getConfiguration() {
        return this.configuration;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public String getConfigurationFileName() {
        return this.configurationFile.getName();
    }

    public String getConfigurationFilePath() {
        return this.configurationFile.getAbsolutePath();
    }

    public LdapConfigurationException createConfigurationException(String name, String message) {
        return new LdapConfigurationException(name, this.getConfigurationFilePath(), message);
    }

    public LdapConfigurationException createConfigurationException(String name, String message, Throwable cause) {
        return new LdapConfigurationException(name, this.getConfigurationFilePath(), message, cause);
    }

    private LdapConfiguration loadConfiguration() {
        LdapConfiguration configuration = null;
        if (!this.configurationFile.exists()) {
            this.throwConfigurationError("File not found.", null);
        } else if (!this.configurationFile.isFile()) {
            this.throwConfigurationError("Path is not a file.", null);
        } else if (!this.configurationFile.canRead()) {
            this.throwConfigurationError("File cannot be read.", null);
        }
        try {
            String packageName = this.getClass().getPackage().getName() + ".conf";
            JAXBContext jaxbContext = JAXBContext.newInstance((String)packageName);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(this.getConfigurationFile());
            configuration = (LdapConfiguration)element.getValue();
        }
        catch (JAXBException e) {
            String msg = "Configuration file cannot be unmarshalled to configuration object model.";
            this.throwConfigurationError(msg, e);
        }
        return configuration;
    }

    private void throwConfigurationError(String message, Throwable cause) {
        LdapConfigurationException error = null;
        String name = this.getConfigurationFileName();
        error = cause == null ? this.createConfigurationException(name, message) : this.createConfigurationException(name, message, cause);
        logger.error((Object)error.getLocalizedMessage());
        throw error;
    }
}

