/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.internal;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DataSourceProvider {
    private static final Logger logger = Logger.getLogger((String)DataSourceProvider.class.getName());
    public static final String DATASOURCE_NAME_PROPERTY = "datasource.name";
    public static final String DEFAULT_DATASOURCE_JNDI_NAME = "java:/neptune/datasource";

    public static DataSource getDataSource() {
        return DataSourceProvider.getDataSource(DEFAULT_DATASOURCE_JNDI_NAME);
    }

    public static DataSource getDataSource(String dataSourceName) {
        DataSource dataSource = null;
        InitialContext context = null;
        try {
            context = new InitialContext();
            Object object = context.lookup(dataSourceName);
            if (!(object instanceof DataSource)) {
                throw new RuntimeException("The object registered in naming context for name: " + dataSourceName + " is not a data source, found: " + object.getClass().getName());
            }
            dataSource = (DataSource)DataSource.class.cast(object);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to get data source from naming context using name: " + dataSourceName + ", error: " + e.getLocalizedMessage(), e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    String msg = "Error closing naming context: " + e.getLocalizedMessage();
                    logger.warn((Object)msg, (Throwable)e);
                }
            }
        }
        return dataSource;
    }
}

