/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.internal;

import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.internal.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.security.auth.spi.Util;

public class LocalUserAuthenticationService
implements IUserAuthenticationService {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final String HASH_ALGORITHM = "SHA";

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public void authenticateUser(String userName, String password, String externalKey) throws LoginException {
        boolean isExistingUser = false;
        String expectedPassword = null;
        boolean isActive = false;
        password = this.hashPassword(password);
        String name = this.getPropertyValue("datasource.name", "java:/neptune/datasource");
        ConnectionManager connectionManager = new ConnectionManager(name);
        boolean isConnectionActive = connectionManager.isCurrentConnectionActive();
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = connectionManager.getCurrentConnection();
            String query = "SELECT PASSWORD, ACTIVE FROM CMS_USER WHERE USERNAME = :1";
            statement = connection.prepareStatement(query);
            statement.setString(1, userName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                isExistingUser = true;
                expectedPassword = resultSet.getString(1);
                isActive = "1".equals(resultSet.getString(2));
            }
            connectionManager.closeSQLStatement(statement);
            if (!isConnectionActive) {
                connectionManager.closeCurrentConnection();
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to execute local authentication query when authenticating user " + userName + "error: " + e.getLocalizedMessage();
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                connectionManager.closeSQLStatement(statement);
                if (!isConnectionActive) {
                    connectionManager.closeCurrentConnection();
                }
                throw throwable;
            }
        }
        if (isExistingUser) {
            if ("_SSO_OAuth".equals(externalKey)) {
                try {
                    Object ssoPrincipal;
                    HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
                    HttpSession session = request.getSession(false);
                    if (session != null && (ssoPrincipal = session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL)) != null) {
                        password = expectedPassword;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (password == null || !password.equals(expectedPassword)) {
                throw new FailedLoginException("The password is incorrect.");
            }
            if (!isActive) {
                throw new FailedLoginException("The user is not active.");
            }
        } else {
            throw new AccountNotFoundException("The user name is invalid.");
        }
    }

    private String getPropertyValue(String name, String defaultValue) {
        String value = this.properties.get(name);
        return value != null ? value : defaultValue;
    }

    private String hashPassword(String password) {
        return Util.createPasswordHash((String)HASH_ALGORITHM, (String)"HEX", null, null, (String)password);
    }
}

