/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.alerts.rest.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class RestClient {
    String name;
    String password;
    int connTimeout = 2000;
    int readTimeout = 4000;
    private static final Logger logger = Logger.getLogger(RestClient.class);

    public RestClient(String name, String password) {
        this.name = name;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsonAlerts(String url) {
        String jSonString = "";
        HttpURLConnection conn = null;
        try {
            javax.net.ssl.TrustManager[] trustAllCerts = new TrustManager[]{new TrustManager()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            String authString = this.name + ":" + this.password;
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
            String authStringEnc = new String(authEncBytes);
            URL urlComponent = new URL(url);
            conn = (HttpURLConnection)urlComponent.openConnection();
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setConnectTimeout(this.connTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                jSonString = builder.toString();
            } else {
                logger.info((Object)(url + " connection failed: HTTP error code : " + conn.getResponseCode() + " response message:" + conn.getResponseMessage()));
            }
        }
        catch (SocketTimeoutException e) {
            logger.info((Object)(url + " connection timed-out:" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return jSonString;
    }

    public static void main(String[] args) {
        String name = "admin";
        String pwd = "admin";
        String url = "https://localhost:8443/sample/services/alerts?startTime=2014-01-08%2010:52:30";
        RestClient test = new RestClient(name, pwd);
        System.out.println(test.getJsonAlerts(url));
    }

    private class TrustManager
    implements X509TrustManager {
        private TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

