package com.tandbergtv.neptune.ui.realm.client.alerts.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/realm/IAlertsUIService")
public interface IAlertsUIService  extends RemoteService {

	/**
	 * 		Return count for all alert types.
	 * 
	 * @return
	 * @throws NeptuneException
	 */
	UiAlertCounts getAlertCounts() throws NeptuneException;

	/**
	 * 		Return all the aggregated alert items.
	 * 
	 * @return
	 * @throws NeptuneException
	 */
	List<UiAlertItem> getAlertItems() throws NeptuneException;

	/**
	 * 		Return list of aggregated alert items , given the index and page size
	 * 
	 * @return
	 * @throws NeptuneException
	 */
	List<UiAlertItem> getAlertItems(int index, int pageSize) throws NeptuneException;
	
	/**
	 *  Attempts to fix the {@code UiRecoveryItem} using the specified URL and any
	 *  associated parameters
	 * 
	 * @param UiRecoveryItem recoveryItem the item to recover
	 * @return
	 * @throws NeptuneException
	 */
	String recover(UiRecoveryItem recoveryItem);
}
