package com.tandbergtv.neptune.ui.realm.client.alerts.view;

import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class AlertsLazyView extends LazyView {
	private VerticalPanel mainPanel;
	private HeaderPanel headerPanel;
	private SimplePanel widgetPanel;
	private AlertTableView tableView;
	private ResizableContainer container;
	private BusyIndicator busyIndicator = new BusyIndicator(this);

	/* Styles / constants */
	private static final String STYLE_NAME = "realm-UserView"; 
	private static final String STYLE_LIST_VIEW = "listView";
	private static final String STYLE_HEADER_PANEL = STYLE_NAME + "-headerPanel";
	private static final String STYLE_WIDGET_PANEL = STYLE_NAME + "-widgetPanel";
	
	public AlertsLazyView() {
		addStyleName(STYLE_NAME);
	}
	
	/*
	 * Show the header panel
	 */
	private void showHeaderPanel(String heading, String styleName) {
		headerPanel.setLabel(heading);
		headerPanel.setVisible(true);
		mainPanel.setStyleName(styleName);
	}

	/*
	 * Hide the header panel
	 */
	private void hideHeaderPanel() {
		headerPanel.setLabel("");
		headerPanel.setVisible(false);
		mainPanel.setStyleName(STYLE_LIST_VIEW);
	}
	
	@Override
	public String getAnchor() {
		String anchor = null;
		Widget widget = getWidgetInPanel();
		if (tableView != null && widget == tableView) {
			/* Showing the list view, get table anchor */
			anchor = tableView.getAnchor();
		}
		else
			anchor = "";
		return anchor;
	}

	@Override
	protected void setWidgetAnchor(String anchor) {
		tableView = new AlertTableView(busyIndicator, container);
		showTableView();
		tableView.setAnchor(anchor);
		tableView.refresh();
	}

	@Override
	protected Widget createWidget() {
		mainPanel = new VerticalPanel();
		mainPanel.setSpacing(5);
		mainPanel.setStyleName(STYLE_LIST_VIEW);

		/* At the very top is the header panel */
		headerPanel = new HeaderPanel("");
		headerPanel.setVisible(false);
		headerPanel.addStyleName(STYLE_HEADER_PANEL);
		mainPanel.add(headerPanel);
		
		/* Add the widget panel */
		widgetPanel = new SimpleContainer();
		widgetPanel.addStyleName(STYLE_WIDGET_PANEL);
		mainPanel.add(widgetPanel);

		container = new ResizableContainer(widgetPanel, "Alerts", null);
		mainPanel.add(container);
		container.addHeightOffsettingWidget(headerPanel);
		
		return mainPanel;
	}

	/*
	 * Get the widget being displayed in the widget panel
	 */
	private Widget getWidgetInPanel() {
		if (widgetPanel == null)
			return null;

		return widgetPanel.getWidget();
	}

	/*
	 * Set the panel widget
	 */
	private void setWidgetInPanel(Widget widget) {
		widgetPanel.setWidget(widget);
	}
	
	
	/*
	 * Show the table view in the widget panel
	 */
	public void showTableView() {
		setWidgetInPanel(tableView);
		//showHeaderPanel(getConstants().componentListViewHeading(), STYLE_LIST_VIEW);
	}

}
