package com.tandbergtv.neptune.ui.realm.client.settings.view;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.Tree.Resources;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.settings.service.ISettingsUIService;
import com.tandbergtv.neptune.ui.realm.client.settings.service.ISettingsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiComplexSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingGroup;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingVisibility;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageHyperlink;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;

/**
 * Lazy View implementation of Settings Configuration screen.
 * 
 * @author Francisco Bento da Silva Neto
 *
 */
public class SettingsLazyView extends LazyView {
	
	private static final String WARNING_ICON = "realm/images/warning.png";

	private RealmConstants constants = GWT.create(RealmConstants.class);
	
	/* The RPC service */
	private final ISettingsUIServiceAsync service = GWT.create(ISettingsUIService.class);
	
	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
	private static final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";
	private static final String USER_IMAGE_URL = "neptune_framework/images/ico_admin.png";
	
	// Root container
	private VerticalPanel verticalPanel;
	private HeaderPanel headerPanel;
	
	protected TreeWidget settingsTree;
	
	/* Internal state */
	private BusyIndicator busyIndicator;
	
	public static final String TAB_ANCHOR_KEY = "Tab";

	private ResizableContainer resizableTabContainer;

	
    // private ButtonWidget btnSave;
	// private ButtonWidget btnCancel;

	private SimpleContainer settingsFormPanel;
	private SettingsFormUI settingsForm;

	private TextBoxWidget treeSearchWidget;
	

	private ImageWidget dropDownImgCollapse;
	private ImageWidget dropDownImgExpand;
	private static final String EXPAND_ICON = "realm/images/child-expandAll.png";
	private static final String COLLAPSE_ICON = "realm/images/child-collapseAll.png";
	
	/**
	 * We will store the item from the TreeWidget as previous so we can go back
	 * to it if user decide not to change item without saving.
	 */
	TreeItem previousItem = null;

	protected List<UiSettingGroup> allSettings; 
	
	/**
	 * Constructor
	 */
	public SettingsLazyView() {
		//Nothing to do here since this is a lazy view
	}
		
	/**
	 * Shows busy indicator and blocks user interactions to the UI.
	 * hideBusyIndicator method must be called once the blocking operation is over.
	 */
	public void showBusyIndicator() {
		busyIndicator.center();
	}
	
	/**
	 * Hides busy indicator and clears 'block' created by showBusyIndicator
	 */
	public void hideBusyIndicator() {	
		busyIndicator.hide();
	}
	
	@Override
	public String getAnchor() {
		AnchorTokenizer tokenizer = new AnchorTokenizer();
		Map<String, String> anchorTokens = new LinkedHashMap<String, String>();
		return tokenizer.buildAnchor(anchorTokens);
	}
	
	@Override
	protected void setWidgetAnchor(String anchor) {
	}

	@Override
	protected Widget createWidget() {		
		/* Build the busy indicator */
		busyIndicator = new BusyIndicator();
		
		verticalPanel = new VerticalPanel();
		verticalPanel.addStyleName(CONTAINER_PANEL_STYLE_LIST);
		
		headerPanel = new HeaderPanel(constants.settingsPageHeading());
		
		/* Added for ECMS  */
		Image image=new Image(USER_IMAGE_URL);
		image.setStyleName(STYLE_HEADER_IMAGE);
		 
		headerPanel.setImage(image);
			
		verticalPanel.add(headerPanel);

		VerticalContainer treePanel = new VerticalContainer();
		
		
		TreeResource images = new TreeResource();
		
		settingsTree = new TreeWidget(images);
		//settingsTree
		
		previousItem = null;
		
		settingsTree.addSelectionHandler(new SelectionHandler<TreeItem>() {

			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				
				if (previousItem == null) {
					previousItem = event.getSelectedItem();
				}
				boolean goAheadAnyway = true;
				if(settingsForm != null){
					if (settingsForm.haveSettingsChanged()) {
						if (!Window.confirm(constants.settingsUnsaved())) {
							goAheadAnyway = false;
							if (settingsTree.getSelectedItem() != previousItem) {
								settingsTree.setSelectedItem(previousItem,
										false);
							}
							
						}
						
					}
				}
				if (goAheadAnyway) {
					if (event.getSelectedItem() != null) {
						UiSettingGroup group = (UiSettingGroup) event
									.getSelectedItem().getUserObject();
						if (group.getSettings().isEmpty()
									|| !hasVisibleSettings(group)) {
								clearEditorForm();
						} else {
								generateSettingEditorForm((UiSettingGroup) event
										.getSelectedItem().getUserObject());
								previousItem = event.getSelectedItem();
						}
					}
				}
				
			}
			
		});
		
		
		treeSearchWidget = new TextBoxWidget();
		treeSearchWidget.setPlaceHolder("type filter text");
		treeSearchWidget.setWidth("97%");
		
		treeSearchWidget.addKeyPressHandler(new KeyPressHandler() {
			@Override
			public void onKeyPress(KeyPressEvent event) {
				if (event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) {
					clearErrors();
					clearEditorForm();
					applyFilter();
				}
			}
		});
		
		
		
		for(Iterator<TreeItem> i = settingsTree.treeItemIterator(); i.hasNext();){
			TreeItem item = i.next();
			item.setStyleName("treeStyle");
			
		}
		
		
		dropDownImgCollapse=new ImageWidget(COLLAPSE_ICON);
		dropDownImgCollapse.setStyleName("drop-arrow-collapse-all");
		
		dropDownImgCollapse.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				for (Iterator<TreeItem> i = settingsTree.treeItemIterator(); i.hasNext();) {
					TreeItem item = i.next();
					item.setState(false);
				}
			}
		});
		 LabelWidget textLabelCollapse= new LabelWidget("Collapse All");
		textLabelCollapse.setStyleName("settings-view-expand-collapse-style");
		textLabelCollapse.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
//				for(int i=0;i<settingsTree.getItemCount();i++){
//					settingsTree.getItem(i).setState(false);
//					
//				}
				for (Iterator<TreeItem> i = settingsTree.treeItemIterator(); i.hasNext();) {
					TreeItem item = i.next();
					item.setState(false);
				}
			}
		});
		dropDownImgExpand=new ImageWidget(EXPAND_ICON);
		dropDownImgExpand.setStyleName("drop-arrow-expand-all");
		dropDownImgExpand.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				for (Iterator<TreeItem> i = settingsTree.treeItemIterator(); i.hasNext();) {
					TreeItem item = i.next();
					item.setState(true);
				}
				
			}
		});
		
		 LabelWidget textLabelExpand= new LabelWidget("Expand All");
		textLabelExpand.setStyleName("settings-view-expand-collapse-style");
		textLabelExpand.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
//				for(int i=0;i<settingsTree.getItemCount();i++){
//					settingsTree.getItem(i).setState(true);
//					for(int j=0;i<settingsTree.getItem(j).getChildCount();j++){
//						settingsTree.getItem(i).getChild(j).setState(true);
//					}
//				}
				for (Iterator<TreeItem> i = settingsTree.treeItemIterator(); i.hasNext();) {
					TreeItem item = i.next();
					item.setState(true);
				}
				
			}
		});
		
		
		HorizontalPanel horizontalPanel = new HorizontalPanel();
		horizontalPanel.add(dropDownImgExpand);
		horizontalPanel.add(textLabelExpand);
		horizontalPanel.add(dropDownImgCollapse);
		horizontalPanel.add(textLabelCollapse);
		
		/**Code changes start to add new heading*/
		LabelWidget labelWidget = new LabelWidget(constants.settingsTabHeading());
		labelWidget.setStyleName("settingsHeader");
		treePanel.add(labelWidget);
		/**Code changes start to add new heading*/
		
		treePanel.add(treeSearchWidget);
		treePanel.add(horizontalPanel);
		
				
		treePanel.add(settingsTree);
		
		treePanel.setCellHeight(settingsTree, "97%");
		treePanel.setHeight("97%");
		treePanel.setWidth("97%");
		settingsFormPanel = new SimpleContainer();
		
		resizableTabContainer = new ResizableContainer(treePanel, settingsFormPanel, constants.settingsTabHeading(), null);
		resizableTabContainer.addStyleName("SettingsTreePanel");
		resizableTabContainer.setLeftContentWidthPercentage(constants.settingsTabHeading(), 60);
	     resizableTabContainer.getTabContainer().getTabBar().setTabText(0, null);
		
//		btnSave = new ButtonWidget(constants.saveButton());
//		btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
//		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY)) {
//			btnSave.addClickHandler(new ClickHandler() {
//				@Override
//				public void onClick(ClickEvent event) {
//					clearErrors();
//					saveSettings();
//				}
//			});
//		}
//		btnSave.setVisible(false);
//		
//		btnCancel = new ButtonWidget(constants.cancelButton());
//		btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
//		btnCancel.addClickHandler(new ClickHandler() {
//			@Override
//			public void onClick(ClickEvent event) {
//				clearErrors();
//				settingsTree.setSelectedItem(null);
//				clearEditorForm();
//			}
//		});
//		btnCancel.setVisible(false);
//
//		resizableTabContainer.addButton(constants.settingsTabHeading(), btnSave);
//		resizableTabContainer.addButton(constants.settingsTabHeading(), btnCancel);
		
		resizableTabContainer.addHeightOffsettingWidget(headerPanel);
		verticalPanel.add(resizableTabContainer);
//		resizableTabContainer.addTab( new VerticalPanel(), "test");
		showBusyIndicator();
		service.getAllSettingDefinitions(new NeptuneAsyncCallback<List<UiSettingGroup>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				hideBusyIndicator();
				setError(constants.genericError());
			}

			@Override
			public void onNeptuneSuccess(List<UiSettingGroup> result) {
				hideBusyIndicator();
				allSettings = result;
				buildSettingsTree(result);
			}
		});
		
		service.hasInconsistentGroups(new AsyncCallback<Boolean>() {
			@Override
			public void onSuccess(Boolean hasErrors) {
				if (hasErrors) {
					setInfoMessage(constants.inconsistentSettings());
				}
			}
			
			@Override
			public void onFailure(Throwable caught) {
			}
		});
		
		return verticalPanel;
	}
	
	
	
	protected boolean hasVisibleSettings(UiSettingGroup group) {
		boolean hasVisibleSettings = false;
		
		for (UiSettingDefinition setting : group.getSettings()) {
			if (setting.getVisibility() == null || setting.getVisibility().equals(UiSettingVisibility.visible)) {
				hasVisibleSettings = true;
				break;
			}
		}
		
		return hasVisibleSettings;
	}

	protected void applyFilter() {
		service.findSettingDefinitions(treeSearchWidget.getText(), new NeptuneAsyncCallback<List<UiSettingGroup>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				hideBusyIndicator();
				setError(constants.genericError());
			}

			@Override
			public void onNeptuneSuccess(List<UiSettingGroup> result) {
				hideBusyIndicator();
				buildSettingsTree(result);
				// expands all items
				for (Iterator<TreeItem> i = settingsTree.treeItemIterator(); i.hasNext();) {
					TreeItem item = i.next();
					item.setState(true);
				}
			}
		});
	}

	protected void clearEditorForm() {
		clearErrors();
		settingsFormPanel.setWidget(new SimpleContainer());
		//settingsFormPanel.removeStyleName("settingsFormStyle");
		//hideButtons();
	}

	protected void saveSettings() {
		
		if (settingsTree.getSelectedItem() != null) {
			Map<String, String> settings = settingsForm.applyChanges();
			clearErrors();
			showBusyIndicator();
			
			service.saveSettings(settingsForm.getSettingGroup(), settings, new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
					hideBusyIndicator();
					if (caught instanceof ValidationException) {
						ValidationException error = (ValidationException) caught;
						setErrorMessages(error.getValidationMessages());
					} else {
						setError(constants.genericError());
					}
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					// group doesnt contain errors anymore.
					UiSettingGroup group = settingsForm.getSettingGroup();
					if (group.hasErrors()) {
						settingsForm.getSettingGroup().markHasErrors(false);
						settingsTree.getSelectedItem().setHTML(LocalizedSettingUtil.toLocalizedString(group.getDisplayName()));
					}
					else {
						settingsForm.resetOriginalValues();
							}
					
					hideBusyIndicator();
					setInfoMessage(constants.settingsSaved());
					if (settingsForm.requiresRestart()) {
						Window.alert(constants.restartRequired());
					} 

				}

			});
		}
	}

	protected void generateSettingEditorForm(final UiSettingGroup group) {
		clearErrors();
		showBusyIndicator();
		service.getSettingsValues(group.getPath(), new NeptuneAsyncCallback<Map<String, String>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				hideBusyIndicator();
				setError(constants.genericError());
			}

			@Override
			public void onNeptuneSuccess(Map<String, String> result) {
				hideBusyIndicator();
				renderSettingsForm(group, result);
			}

		});
		service.validateSettingGroup(group.getPath(), new NeptuneAsyncCallback<List<String>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(List<String> result) {
				if (!result.isEmpty()) {
					setErrorMessages(result);
				}
			}

		});
	}

	protected void renderSettingsForm(final UiSettingGroup group,
								      Map<String, String> values) {
		
		if (!group.getSettings().isEmpty() 
		 && group.getSettings().get(0) instanceof UiComplexSetting) {
			// is a complex setting
			settingsForm = new ComplexSettingsUI(this);			
		} else {
			// is a basic setting
			settingsForm = new BasicSettingsUI(this);
		}

		settingsForm.setSettingGroup(group);
		settingsForm.setSettingsValues(values);
		Widget settingsFormWidget = settingsForm.createUI();
		settingsFormPanel.setWidget(settingsFormWidget);
		
		settingsFormPanel.setStyleName("settingsFormStyle");
		//showButtons();
	}

	// protected void showButtons() {
	// btnSave.setVisible(ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY));
	// btnCancel.setVisible(true);
	// resizableTabContainer.updateSize();
	// }
	//	
	// private void hideButtons() {
	// btnSave.setVisible(false);
	// btnCancel.setVisible(false);
	// }

	
	protected void buildSettingsTree(List<UiSettingGroup> result) {
		settingsTree.clear();
		
		for (UiSettingGroup group : result) {
			
			TreeItem rootItem = createTreeNode(group);
			
			settingsTree.addItem(rootItem);
			appendChildrenNode(group, rootItem);
		}
	}

	protected TreeItem createTreeNode(UiSettingGroup group) {
		TreeItem rootItem = null;
		
		if (group.hasErrors()) {
			HorizontalContainer treeWidget = new HorizontalContainer();
			ImageWidget image = new ImageWidget(WARNING_ICON);
			image.setTitle("Warning");
			image.addStyleName("SettingsUiWarningIcon");
			treeWidget.add(image);
			LabelWidget label = new LabelWidget(LocalizedSettingUtil.toLocalizedString(group.getDisplayName()));
			treeWidget.add(label);
			rootItem = new TreeItem(treeWidget);
		} else {
			rootItem = new TreeItem(LocalizedSettingUtil.toLocalizedString(group.getDisplayName()));
			
		}
		
		rootItem.setTitle(group.getPath());
		rootItem.setUserObject(group);
		
		return rootItem;
	}

	private void appendChildrenNode(UiSettingGroup group, TreeItem parentItem) {
		for (UiSettingGroup child : group.getChildren()) {
			if (child.getChildren().isEmpty() && !hasVisibleSettings(child)) {
				// is a leaf node and it doesn't have any visible settings, skip it
			} else {
				
				TreeItem item = createTreeNode(child);
				parentItem.addItem(item);
				appendChildrenNode(child, item);
			}
		}
	}

	/*
	 * Fire an anchor change event
	 */
	protected void fireViewAnchorChange() {
		String anchor = getAnchor();
		fireEvent(new ViewAnchorChangeEvent(anchor));
	}
	
	
	public void setError(String message) {
		resizableTabContainer.getMessageArea().setErrorMessage(message);
		resizableTabContainer.updateSize();
	}
	
	/**
	 * Display the list of error messages to the user
	 * 
	 * @param messages The messages to display
	 */
	public void setErrorMessages(List<String> errorMessages) {
		/* Show an alert with the messages */
		StringBuilder buf = new StringBuilder();
		
		buf.append("<ul>");
		/* Build a list of the messages separated by new lines */
		for (String message : errorMessages) {
			buf.append("<li>");
			buf.append(message);
			buf.append("</li>");
		}
		buf.append("</ul>");
		resizableTabContainer.setErrorHTML(buf.toString());
	}
	
	public void setInfoMessage(String info) {
		resizableTabContainer.getMessageArea().setInfoMessage(info);
		resizableTabContainer.updateSize();
	}

	/**
	 * Clears the errors/warnings displayed in List as well as Create sections
	 */
	public void clearErrors() {
		resizableTabContainer.setErrorMessage(null);
		resizableTabContainer.setInfoMessage(null);
	}
	

}

