package com.tandbergtv.neptune.ui.realm.client.alerts.service;

import java.util.Comparator;

public enum UiAlertComparator implements Comparator<UiAlertItem> {
	
	TIME_SORT_ASC {
		public int compare(UiAlertItem a1, UiAlertItem a2) {
			return a1.getTimeStamp().compareTo(a2.getTimeStamp());
		}
	},
	
	TIME_SORT_DESC {
		public int compare(UiAlertItem a1, UiAlertItem a2) {
			return -1 * a1.getTimeStamp().compareTo(a2.getTimeStamp());
		}
	},
	
	NAME_SORT_ASC {
		public int compare(UiAlertItem a1, UiAlertItem a2) {
			return a1.getItemName().compareTo(a2.getItemName());
		}	
	},
	
	NAME_SORT_DESC {
		public int compare(UiAlertItem a1, UiAlertItem a2) {
			return -1 * a1.getItemName().compareTo(a2.getItemName());
		}	
	};

	public static Comparator<UiAlertItem> getComparator(final UiAlertComparator... searchOptions) {
		return new Comparator<UiAlertItem>() {
			public int compare(UiAlertItem a1, UiAlertItem a2) {
				for(UiAlertComparator searchOption : searchOptions) {
					int result = searchOption.compare(a1, a2);
					if (result != 0) {
						return result;
					}					
				}
				return 0;
			}
		};
	}

}
