package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table.RefreshListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.SortFeatureImages;

final class ModuleTable extends Composite {

	private final Map<Long, CheckBoxWidget> checkBoxMap;
	private Collection<Long> enabledPermissions;
	private Table<Long, ModuleRecord> table;
	private final SortFeatureImpl<Long, ModuleRecord> sortFeature;
	private ModuleDataProvider modDataProvider;
	
	private final RoleDetailsImages bundle=GWT.create(RoleDetailsImages.class);

	private static final String TABLE_STYLE			= "permissions-table";

	
	public ModuleTable(List<UiModule> model) {
		checkBoxMap = new HashMap<Long, CheckBoxWidget>();
		enabledPermissions = new ArrayList<Long>();
		
		modDataProvider = new ModuleDataProvider(this, model);
		modDataProvider.initialize(null);
		table = new Table<Long, ModuleRecord>(modDataProvider);
		table.addStyleName(TABLE_STYLE);
		sortFeature = new SortFeatureImpl<Long, ModuleRecord>(modDataProvider.columnModuleName, SortOrder.ASCENDING );
		//sortFeature.getSortableColumns().addAll(modDataProvider.getColumns());
		table.addSortFeature(sortFeature);
		
		
		HorizontalPanel hpCreate=getTable().getHeaderWidgetForColumn(modDataProvider.columnCreatePerm);
		ImageResource resourceCreate = bundle.create();
		ImageWidget imageCreate= new ImageWidget();
		imageCreate.setResource(resourceCreate);
		Label labelWidgetCreate = getTable().getHeaderWidgetLabelForColumn(modDataProvider.columnCreatePerm);
		hpCreate.remove(labelWidgetCreate);
		hpCreate.add(imageCreate);
		hpCreate.add(labelWidgetCreate);
		
		
		HorizontalPanel hpDelete=getTable().getHeaderWidgetForColumn(modDataProvider.columnDeletePerm);
		ImageResource resourceDelete = bundle.delete();
		ImageWidget imageDelete= new ImageWidget();
		imageDelete.setResource(resourceDelete);
		Label labelWidgetDelete = getTable().getHeaderWidgetLabelForColumn(modDataProvider.columnDeletePerm);
		hpDelete.remove(labelWidgetDelete);
		hpDelete.add(imageDelete);
		hpDelete.add(labelWidgetDelete);
		
		
		HorizontalPanel hpEdit=getTable().getHeaderWidgetForColumn(modDataProvider.columnModifyPerm);
		ImageResource resourceEdit = bundle.edit();
		ImageWidget imageEdit= new ImageWidget();
		imageEdit.setResource(resourceEdit);
		Label labelWidgetEdit = getTable().getHeaderWidgetLabelForColumn(modDataProvider.columnModifyPerm);
		hpEdit.remove(labelWidgetEdit);
		hpEdit.add(imageEdit);
		hpEdit.add(labelWidgetEdit);
		
		HorizontalPanel hpView=getTable().getHeaderWidgetForColumn(modDataProvider.columnViewPerm);
		ImageResource resourceView = bundle.view();
		ImageWidget imageView= new ImageWidget();
		imageView.setResource(resourceView);
		Label labelWidgetView = getTable().getHeaderWidgetLabelForColumn(modDataProvider.columnViewPerm);
		hpView.remove(labelWidgetView);
		hpView.add(imageView);
		hpView.add(labelWidgetView);
		
		HorizontalPanel hpOther=getTable().getHeaderWidgetForColumn(modDataProvider.columnOtherPerms);
		ImageResource resourceOther = bundle.other();
		ImageWidget imageOther= new ImageWidget();
		imageView.setResource(resourceOther);
		Label labelWidgetOther = getTable().getHeaderWidgetLabelForColumn(modDataProvider.columnOtherPerms);
		hpOther.remove(labelWidgetOther);
		hpOther.add(imageOther);
		hpOther.add(labelWidgetOther);
		
		
		initializeTable(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				/* Should not happen */
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				table.reset(false);
				table.showListView();
				table.refresh();
			}
		});
		
		table.addRefreshListener( new ModuleTableRefreshListener() );
		
		
		
		initWidget( table );
	}
	
	public void reset() {
		if (getWidget() == null)
			return;

		if (table.isInitialized()) {
			table.reset();
			table.showListView();
		}
	}
	
	private void initializeTable(final AsyncCallback<Void> callback) {
		if (table.isInitialized()) {
			callback.onSuccess(null);
			return;
		}

		table.initialize(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				/* Will never happen */
				if (callback != null)
					callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				if (callback != null)
					callback.onSuccess(result);
			}
		});
	}	
	
	public void setData(Collection<Long> data) {
		enabledPermissions = data;
		
		// reset to false
		for (CheckBoxWidget checkBox : checkBoxMap.values())
			checkBox.setValue(false);

		// set the checked ones
		for (Long permissionId : data)
			checkBoxMap.get(permissionId).setValue(true);
	}

	public Collection<Long> getData() {
		Collection<Long> checked = new ArrayList<Long>();
		for (Long key : checkBoxMap.keySet())
			if (checkBoxMap.get(key).getValue())
				checked.add(key);
		return checked;
	}
	
	public Table<Long, ModuleRecord> getTable() {
		return table;
	}
	
	public Map<Long, CheckBoxWidget> getCheckBoxMap() {
		return checkBoxMap;
	}
	
	public Collection<Long> getEnabledPermissions() {
		return enabledPermissions;
	}
	
	private class ModuleTableRefreshListener implements RefreshListener {
	
		@Override
		public void updated() {
			for (Long key : getEnabledPermissions() ) {
				if( getCheckBoxMap().get(key) != null ) {
					getCheckBoxMap().get(key).setValue(true);
				}
			}
			
		}

	}

}
