package com.tandbergtv.neptune.ui.framework.client;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;

public class UncaughtExceptionDispatcher implements
		GWT.UncaughtExceptionHandler {
	private final Map<Class<? extends Throwable>, NeptuneUncaughtExceptionHandler<Throwable>> throwableClassToExceptionHandlerMap;

	public UncaughtExceptionDispatcher() {
		throwableClassToExceptionHandlerMap = new HashMap<Class<? extends Throwable>, NeptuneUncaughtExceptionHandler<Throwable>>();
	}

	public void onUncaughtException(Throwable e) {
		NeptuneUncaughtExceptionHandler<Throwable> handler = throwableClassToExceptionHandlerMap
				.get(e.getClass());
		if (handler == null) {
			Window.alert(e.getClass().toString() + ':' + e.getMessage());
		}
		handler.onUncaughtException(e);
	}

	@SuppressWarnings("unchecked")
	public <E extends Throwable> void registerHandler(Class<E> clazz,
			NeptuneUncaughtExceptionHandler<E> handler) {
		throwableClassToExceptionHandlerMap.put(clazz, (NeptuneUncaughtExceptionHandler<Throwable>)handler);
	}

}
