/*
 * Created on Jul 23, 2012
 * 
 * (C) Copyright Ericsson Television Inc.
 */

package com.tandbergtv.neptune.ui.framework.client.application;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event triggered on selection of a menu item that requires an action to be performed.
 * 
 * @author Vijay Silva
 */
public class MenuItemSelectionEvent extends GwtEvent<MenuItemSelectionHandler> {

	/* The Handler type */
	private static Type<MenuItemSelectionHandler> TYPE;
	private boolean canceled = false;

	/**
	 * Constructor
	 */
	public MenuItemSelectionEvent() {
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<MenuItemSelectionHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<MenuItemSelectionHandler>();
		}

		return TYPE;
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<MenuItemSelectionHandler> getAssociatedType() {
		return getType();
	}

	@Override
	protected void dispatch(MenuItemSelectionHandler handler) {
		handler.onMenuItemSelected(this);
	}

	/**
	 * Cancel the event causing an action taken for the selection to be canceled
	 */
	public void cancel() {
		this.canceled = true;
	}

	/**
	 * Determine if the event has been canceled
	 * 
	 * @return the canceled
	 */
	public boolean isCanceled() {
		return canceled;
	}
}
