package com.tandbergtv.neptune.ui.realm.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.realm.client.alerts.view.AlertMessagesPortlet;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.networkelements.view.ClusterStatusPortlet;
import com.tandbergtv.neptune.ui.realm.client.networkelements.view.HAView;
import com.tandbergtv.neptune.ui.realm.client.settings.view.SettingsLazyView;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleListPanel;
import com.tandbergtv.neptune.ui.realm.client.tab.user.view.UserView;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

public class RealmComponent extends ComponentBase {

	public static final String IS_HA_LICENSED_KEY = "isHALicensed";
	
	private final RealmConstants constants = GWT.create(RealmConstants.class);

	private boolean isHALicensed;

	@Override
	public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink,
	        ServiceLoader serviceLoader, Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);

		isHALicensed = getBooleanValue(IS_HA_LICENSED_KEY);
	}
	
	/*
	 * Get the boolean value for a property
	 */
	private boolean getBooleanValue(String property) {
		return Boolean.parseBoolean(info.get(property));
	}

	
	public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
		List<PortletFactory> portlets = new ArrayList<PortletFactory>();
		if (isHALicensed) {
			portlets.add(new RealmPortletFactory(new ClusterStatusPortlet()));
		}
		
		/*Todo: get from Settings and show alerts portlet*/
		int refreshTimeMillis = 30000;
		boolean showAlerts = false;
		if (showAlerts)
			portlets.add(new RealmPortletFactory(new AlertMessagesPortlet(refreshTimeMillis)));
		return portlets;
	}

	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
		List<MenuItemBase> adminGroup = new ArrayList<MenuItemBase>();
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.USER_VIEW)) {
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(new UserView());
			String displayName = constants.userMenuItem();
			final WidgetMenuItem menuItem = new WidgetMenuItem("User", displayName, factory,
			        factory.getAnchorChangeListener());
			factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);
		}

		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.ROLE_VIEW)) {
			RoleListPanel roleListPanel = new RoleListPanel();
			String displayName = constants.roleMenuItem();
			WidgetFactory factory = new SingletonWidgetFactory(roleListPanel);
			final WidgetMenuItem menuItem = new WidgetMenuItem("Role", displayName, factory,
			        roleListPanel.getTableProvider().getAnchorChangeListener());
			roleListPanel.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);
		}
		
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.BC_MODIFY)) {
			HAView haView = new HAView();
			String displayName = constants.haAdminMenuItem();
			WidgetFactory factory = new SingletonWidgetFactory(haView);
			final WidgetMenuItem menuItem = new WidgetMenuItem("BC", displayName, factory,
					haView);
			adminGroup.add(menuItem);
		}

		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_VIEW)) {
			String displayName = constants.settingsMenuItem();
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(new SettingsLazyView());
			final WidgetMenuItem menuItem = new WidgetMenuItem("Settings", displayName, factory,
			        factory.getAnchorChangeListener());
			factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);
		}

		/* Always return the group even if its empty */
		tabs.add(new GroupMenuItem("Admin", adminGroup));
		return tabs;
	}

	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		return new ArrayList<E>();
	}

	@Override
	public String getName() {
		return "REALM";
	}

	@Override
	public String getDisplayName() {
		return constants.componentDisplayName();
	}
	
	private final class RealmPortletFactory implements PortletFactory {
		private Portlet portlet;

		public RealmPortletFactory(Portlet portlet) {
			this.portlet = portlet;
		}

		@Override
		public Portlet getInstance() {
			return portlet;
		}

		@Override
		public void release(Portlet widget) {
			this.portlet = null;
		}

		@Override
		public Component getComponent() {
			return RealmComponent.this;
		}
	};
}
