package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiRole implements IsSerializable {
	private UiRoleKey key = new UiRoleKey();
	private String name;
	private Collection<Long> permissionIds = new ArrayList<Long>(0);
	private String description;
	private Integer userCount;
	private boolean adminRole;

	public Long getId() {
		return key.getId();
	}

	public void setId(Long id) {
		this.key.setId(id);
	}

	public UiRoleKey getKey() {
		return key;
	}

	public void setKey(UiRoleKey key) {
		if (key == null)
			key = new UiRoleKey();

		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getUserCount() {
		return userCount;
	}

	public void setUserCount(Integer userCount) {
		this.userCount = userCount;
	}

	public Collection<Long> getPermissionIds() {
		return permissionIds;
	}

	public void setPermissionIds(Collection<Long> permissionIds) {
		this.permissionIds = permissionIds;
	}

	/**
	 * Determine if the role is an administrator role
	 * 
	 * @return flag indicating if this role is an administrator role
	 */
	public boolean isAdministratorRole() {
		return this.adminRole;
	}

	/**
	 * Set the flag to determine if this role is an administrator role
	 * @param adminRole flag indicating if this role is an administrator role
	 */
	public void setAdministratorRole(boolean adminRole) {
		this.adminRole = adminRole;
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return key.hashCode() + 71;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (!(obj instanceof UiRole))
			return false;

		/* Must have the same keys */
		UiRole other = (UiRole) obj;
		return key.equals(other.key);
	}
}
