/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.util.paging;

import com.tandbergtv.cms.portal.util.paging.PageSource;
import com.tandbergtv.cms.portal.util.paging.PageTarget;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.CFlowStack;
import org.aspectj.runtime.internal.Conversions;

@Aspect
public class PagingAspect {
    private static final Logger LOGGER;
    private ThreadLocal<Integer> _start = new ThreadLocal();
    private ThreadLocal<Integer> _length = new ThreadLocal();
    private ThreadLocal<String> _sortBy = new ThreadLocal();
    private ThreadLocal<Boolean> _isAscending = new ThreadLocal();
    private ThreadLocal<Integer> _count = new ThreadLocal();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ PagingAspect ajc$perSingletonInstance;
    public static final /* synthetic */ CFlowStack ajc$cflowStack$0;

    static {
        PagingAspect.ajc$cflowStack$0 = new CFlowStack();
        try {
            LOGGER = Logger.getLogger(PagingAspect.class);
            PagingAspect.ajc$perSingletonInstance = new PagingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="(call(javax.persistence.Query javax.persistence.EntityManager.createQuery(java.lang.String)) && (args(queryString) && target(entityManager)))", argNames="entityManager,queryString")
    /* synthetic */ void ajc$pointcut$$pageableQueryCreation$3e8(EntityManager entityManager, String queryString) {
    }

    @Pointcut(value="(execution(@com.tandbergtv.cms.portal.util.paging.PageTarget * *(..)) && @annotation(pageTarget))", argNames="pageTarget")
    /* synthetic */ void ajc$pointcut$$pagingTargetCall$49b(PageTarget pageTarget) {
    }

    @Pointcut(value="(execution(@com.tandbergtv.cms.portal.util.paging.PageSource * *(int, int, java.lang.String, boolean)) && (args(beginIndex, length, sortBy, isAscending) && @annotation(pageSource)))", argNames="pageSource,beginIndex,length,sortBy,isAscending")
    /* synthetic */ void ajc$pointcut$$pagingSourceCall$50c(PageSource pageSource, int beginIndex, int length, String sortBy, boolean isAscending) {
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="pagingSourceCall(pageSource, start, length, sortBy, isAscending)", argNames="pageSource,start,length,sortBy,isAscending,ajc$aroundClosure")
    public Object ajc$around$com_tandbergtv_cms_portal_util_paging_PagingAspect$1$cf9f17f3(PageSource pageSource, int start, int length, String sortBy, boolean isAscending, AroundClosure ajc$aroundClosure) {
        this._start.set(start);
        this._length.set(length);
        this._sortBy.set(sortBy);
        this._isAscending.set(isAscending);
        Object returnValue = ajc$aroundClosure.run(new Object[]{pageSource, Conversions.intObject((int)start), Conversions.intObject((int)length), sortBy, Conversions.booleanObject((boolean)isAscending)});
        try {
            StringBuilder builder = new StringBuilder(pageSource.countBeanPropertyName());
            builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
            builder.insert(0, "set");
            if (this._count.get() != null) {
                Method method = returnValue.getClass().getMethod(builder.toString(), Integer.TYPE);
                method.invoke(returnValue, this._count.get());
            }
        }
        catch (Exception e) {
            PagingAspect.LOGGER.error((Object)e);
        }
        this._start.set(null);
        this._length.set(null);
        this._sortBy.set(null);
        this._isAscending.set(null);
        this._count.set(null);
        return returnValue;
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="(pageableQueryCreation(entityManager, queryString) && (!within(PagingAspect) && cflow(pagingTargetCall(pageTarget))))", argNames="pageTarget,entityManager,queryString,ajc$aroundClosure")
    public Query ajc$around$com_tandbergtv_cms_portal_util_paging_PagingAspect$2$577028b9(PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (this._start.get() == null || this._length.get() == null || this._sortBy.get() == null || this._isAscending.get() == null) {
            return PagingAspect.ajc$around$com_tandbergtv_cms_portal_util_paging_PagingAspect$2$577028b9proceed(pageTarget, entityManager, queryString, ajc$aroundClosure);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)this._sortBy.get()).append(' ');
        if (((Boolean)this._isAscending.get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        Query query = PagingAspect.ajc$around$com_tandbergtv_cms_portal_util_paging_PagingAspect$2$577028b9proceed(pageTarget, entityManager, builder.toString(), ajc$aroundClosure);
        query.setFirstResult(((Integer)this._start.get()).intValue());
        query.setMaxResults(((Integer)this._length.get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        this._count.set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }

    static /* synthetic */ Query ajc$around$com_tandbergtv_cms_portal_util_paging_PagingAspect$2$577028b9proceed(PageTarget this_, EntityManager entityManager, String string, AroundClosure aroundClosure) throws Throwable {
        return (Query)aroundClosure.run(new Object[]{this_, entityManager, string});
    }

    public static PagingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com_tandbergtv_cms_portal_util_paging_PagingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length(PagingAspect pagingAspect, ThreadLocal threadLocal) {
        pagingAspect._length = threadLocal;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy(PagingAspect pagingAspect, ThreadLocal threadLocal) {
        pagingAspect._sortBy = threadLocal;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$LOGGER(Logger logger) {
        LOGGER = logger;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending(PagingAspect pagingAspect, ThreadLocal threadLocal) {
        pagingAspect._isAscending = threadLocal;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count(PagingAspect pagingAspect, ThreadLocal threadLocal) {
        pagingAspect._count = threadLocal;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start(PagingAspect pagingAspect, ThreadLocal threadLocal) {
        pagingAspect._start = threadLocal;
    }
}

