/*
 * Created on Feb 8, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.dnd;

import com.google.gwt.user.client.ui.FlexTable;

/**
 * Event triggered after moving a table row using drag and drop
 * 
 * @author Vijay Silva
 */
public class TableRowMoveEvent {

	/* Properties */
	private FlexTable source;
	private int oldRowIndex;
	private int rowIndex;

	/**
	 * Constructor
	 * 
	 * @param table The table on which the move operation was performed
	 * @param oldIndex The index of the moved row before the move operation started
	 * @param currentIndex The index of the moved row after completion of the move operation
	 */
	public TableRowMoveEvent(FlexTable table, int oldIndex, int currentIndex) {
		this.source = table;
		this.oldRowIndex = oldIndex;
		this.rowIndex = currentIndex;
	}

	/**
	 * Get the table on which the move operation was performed
	 * 
	 * @return The table
	 */
	public FlexTable getSource() {
		return source;
	}

	/**
	 * Get the current index of the moved row
	 * 
	 * @return The row index
	 */
	public int getRowIndex() {
		return rowIndex;
	}

	/**
	 * Get the row index before the move operation began
	 * 
	 * @return The old row index
	 */
	public int getOldRowIndex() {
		return oldRowIndex;
	}
}
