/*
 * Created on Sep 10, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import static com.google.gwt.user.client.ui.HasHorizontalAlignment.ALIGN_CENTER;
import static com.google.gwt.user.client.ui.HasHorizontalAlignment.ALIGN_LEFT;
import static com.google.gwt.user.client.ui.HasHorizontalAlignment.ALIGN_RIGHT;
import static com.google.gwt.user.client.ui.HasVerticalAlignment.ALIGN_MIDDLE;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ListBox;
import com.tandbergtv.neptune.widgettoolkit.client.i18n.NeptuneWidgetConstants;
import com.tandbergtv.neptune.widgettoolkit.client.i18n.NeptuneWidgetMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.HasPageNavigationHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.HasPageResizeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageResizeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageResizeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.PageFeatureImages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * The widget that contains all paging information used by the page feature handler for the table
 * 
 * @author Vijay Silva
 */
public abstract class PageWidget extends Composite implements HasPageResizeHandler,
        HasPageNavigationHandler {

	/* Input */
	protected PageFeature input;

	/* The Widgets */
	protected final HorizontalContainer container;
	protected final PageFeatureImages imageBundle;
	protected HorizontalContainer pageNavigationPanel;
	
	/* 'Page Size' widgets */
	protected HorizontalContainer pageSizePanel;
	
	//protected Grid pageSizeGrid;  /* Modified for ECMS */
	protected ListBox pageSizeListBox;
		
		
	/* Styles */
	protected static final String STYLE_NAME = "nwt-PageFeatureWidget";

	/* Constants */
	protected static final int DEFAULT_PAGE_NUMBER = 1;

	/* 'Goto Page' widgets */
	protected HorizontalContainer gotoPagePanel;
	protected TextBoxWidget pageNumberWidget;

	protected NeptuneWidgetConstants constants = GWT.create(NeptuneWidgetConstants.class);
	protected NeptuneWidgetMessages messages = GWT.create(NeptuneWidgetMessages.class);
	
	/**
	 * Constructor
	 */
	public PageWidget() {
		this.container = new HorizontalContainer();
		container.setStylePrimaryName(STYLE_NAME);
		this.imageBundle = GWT.create(PageFeatureImages.class);

		initialize();
		initWidget(container);
	}

	// ========================================================================
	// ===================== INPUT
	// ========================================================================

	/**
	 * Get the input used by the widget
	 * 
	 * @return The feature input
	 */
	public PageFeature getInput() {
		return input;
	}

	/**
	 * Set the input to use for this widget
	 * 
	 * @param input The feature input
	 */
	public void setInput(PageFeature input) {
		this.input = input;
	}

	// ========================================================================
	// ===================== EVENT REGISTRATION
	// ========================================================================

	@Override
	public HandlerRegistration addPageNavigationHandler(PageNavigationHandler handler) {
		return addHandler(handler, PageNavigationEvent.getType());
	}

	@Override
	public HandlerRegistration addPageResizeHandler(PageResizeHandler handler) {
		return addHandler(handler, PageResizeEvent.getType());
	}

	// ========================================================================
	// ===================== REFRESH VIEW
	// ========================================================================

	public void refresh() {
		/* Update the style for the page size grid cells */
		updatePageSizePanel();

		/* Update the buttons for the page navigation */
		updatePageNavigationPanel();

		/* Clear the page number widget */
		updatePageNumberText();
	}

	/**
	 * Update the page number shown in the page number widget
	 * 
	 * @param pageNumber The page number, or null to clear the widget
	 */
	public void setPageNumberText(Integer pageNumber) {
		String text = pageNumber == null ? "" : pageNumber.toString();
		this.pageNumberWidget.setText(text);
	}

	/*
	 * Update the page number text box
	 */
	private void updatePageNumberText() {
		int pageNumber = (getInput() != null) ? getInput().getPageNumber() : DEFAULT_PAGE_NUMBER;
		setPageNumberText(pageNumber);
	}

	/*
	 * Update the panel containing the page size options based on the current feature state
	 */
	private void updatePageSizePanel() {
		int[] pageSizes = (getInput() != null) ? getInput().getPageSizes() : new int[0];
		int pageSizesCount = (pageSizes != null) ? pageSizes.length : 0;
		int size = (getInput() != null) ? getInput().getPageSize() : 0;
		
		
				//pageSizeGrid.resizeColumns(pageSizes.length);    /* Modified for ECMS */
				if(pageSizeListBox.getItemCount()!=pageSizesCount)
				{
					pageSizeListBox.clear();
					
					for (int i = 0; i < pageSizesCount; ++i) {
						
						//pageSizeGrid.setWidget(0, i, new LabelWidget(String.valueOf(pageSizes[i])));  /* Modified for ECMS */
						pageSizeListBox.addItem(String.valueOf(pageSizes[i]));
						
						String style = (size == pageSizes[i]) ? TableConstants.STYLE_CURRENT_PAGE_SIZE_CELL
						        : TableConstants.STYLE_PAGE_SIZE_CELL;
						
						//pageSizeGrid.getCellFormatter().setStyleName(0, i, style);    /* Modified for ECMS */
						
					}
				
				}
				
			}
	
	/* Build the 'Page Size' panel */
	private HorizontalContainer buildPageSizePanel() {
		HorizontalContainer panel = new HorizontalContainer();
		panel.setVerticalAlignment(ALIGN_MIDDLE);
		/* add label before page options */
		LabelWidget suffixLabel = new LabelWidget(constants.rowsPerPage());
		suffixLabel.setStyleName(TableConstants.STYLE_GENERAL_TEXT);
		panel.add(suffixLabel);

		
				//pageSizeGrid = new Grid(1, 0);   /* Modified for ECMS */
				//pageSizeGrid.setStyleName(TableConstants.STYLE_PAGE_SIZE_TABLE);
				//pageSizeGrid.addClickHandler(new ClickHandler() {
				pageSizeListBox = new ListBox();
				pageSizeListBox.setStyleName(TableConstants.STYLE_PAGE_SIZE_TABLE);
				pageSizeListBox.setStyleName("ebDropdown-header");
				pageSizeListBox.addChangeHandler(new ChangeHandler() {
				//@Override                                      /* Modified for ECMS */
				//	public void onClick(ClickEvent event) {
				//		handlePageSizeGridClick(event);
				//	}

				@Override
				public void onChange(ChangeEvent event) {
					handlePageSizeGridClick(event);
			
				}
		});
			
				//panel.add(pageSizeGrid);  /* Modified for ECMS */
				panel.add(pageSizeListBox);
			
		panel.setSpacing(TableConstants.PAGESIZE_TEXT_SPACING);

		

		return panel;
	}
	
	/* The 'page size' grid click */
	//private void handlePageSizeGridClick(ClickEvent event) {   /* Modified for ECMS */
	private void handlePageSizeGridClick(ChangeEvent event) {
		/* If there is no input, no event is fired */
		if (getInput() == null)
			return;
		
				//int clickedCellIndex = pageSizeGrid.getCellForEvent(event).getCellIndex();  /* Modified for ECMS */
				int clickedCellIndex = pageSizeListBox.getSelectedIndex();
				
		int size = getInput().getPageSizes()[clickedCellIndex];

		/* Ignore if page size does not change */
		if (size == getInput().getPageSize())
			return;

		/* Fire event indicating that the page size has changed */
		fireEvent(new PageResizeEvent(size, getInput()));
	}
	
	/* Init the widget */
	protected void initialize() {
		/* Initialize the container */
		container.setSpacing(15);
		container.setHorizontalAlignment(ALIGN_CENTER);
		container.setVerticalAlignment(ALIGN_MIDDLE);
			
		
		/* Build and add the 'Page Navigation' panel */
		pageNavigationPanel = buildPageNavigationPanel();
		container.add(pageNavigationPanel);
		container.setCellHorizontalAlignment(pageNavigationPanel,ALIGN_RIGHT);
		container.setCellWidth(pageNavigationPanel, "50%");
	
		/* Build and add the 'Page Size' panel */
		pageSizePanel = buildPageSizePanel();
		container.add(pageSizePanel);
		container.setCellHorizontalAlignment(pageSizePanel,ALIGN_RIGHT); 
		container.setCellWidth(pageSizePanel, "40%");
		

		/* Build and add the 'Goto Page' panel */
		gotoPagePanel = buildGotoPagePanel();
		container.add(gotoPagePanel);
		container.setCellHorizontalAlignment(gotoPagePanel, ALIGN_RIGHT);
		container.setCellWidth(gotoPagePanel, "10%");
		
	}
	
	private HorizontalContainer buildGotoPagePanel() {
		HorizontalContainer panel = new HorizontalContainer();
		panel.setVerticalAlignment(ALIGN_MIDDLE);

		/* Add the 'goto' label */
		LabelWidget gotoPageLabelWidget = new LabelWidget(constants.goToPage());
		gotoPageLabelWidget.setStyleName(TableConstants.STYLE_GENERAL_TEXT);
		panel.add(gotoPageLabelWidget);

		/* Add the page number text box */
		pageNumberWidget = new TextBoxWidget();
		pageNumberWidget.setMaxLength(5);
		pageNumberWidget.setVisibleLength(2);
		pageNumberWidget.setStyleName(TableConstants.STYLE_GENERAL_TEXTBOX); /* Added a New Style for Textbox ECMS  */
		pageNumberWidget.addKeyPressHandler(new KeyPressHandler() {
			@Override
			public void onKeyPress(KeyPressEvent event) {
				handlePageNumberKeyPress(event);
			}
		});
		panel.add(pageNumberWidget);

		return panel;
	}
	
	// ========================================================================
	// ===================== ABSTRACT METHODS
	// ========================================================================
	
	/* Build the 'Page Navigation' panel */
	protected abstract HorizontalContainer buildPageNavigationPanel();

	/* The key press event for the page number widget */
	protected abstract void handlePageNumberKeyPress(KeyPressEvent event);
	
	/*
	 * Update the panel containing the page navigation options based on the current feature state
	 */
	protected abstract void updatePageNavigationPanel();

}
