/*
 * Created on Feb 11, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event indicating that the widget is detached to the document
 * 
 * @author Vijay Silva
 */
public class DocumentDetachEvent extends GwtEvent<DocumentDetachHandler> {

	/* The Handler type */
	private static Type<DocumentDetachHandler> TYPE;

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<DocumentDetachHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<DocumentDetachHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<DocumentDetachHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(DocumentDetachHandler handler) {
		handler.onDetach(this);
	}
}
