/*
 * Created on Sep 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.Feature;

/**
 * The abstract detail feature implementation that ensures the key serializer is present
 * 
 * @author Vijay Silva
 */
public abstract class AbstractDetailFeature<K, R extends Record<K>> implements DetailFeature<K, R> {

	/* Properties */
	private final KeySerializer<K> keySerializer;

	/**
	 * Constructor
	 * 
	 * @param The key serializer
	 */
	public AbstractDetailFeature(KeySerializer<K> keySerializer) {
		this.keySerializer = keySerializer;
	}

	/**
	 * Reseting the feature does nothing
	 * 
	 * @see Feature#reset()
	 */
	@Override
	public void reset() {
	}

	/**
	 * @see DetailFeature#getKeySerializer()
	 */
	@Override
	public KeySerializer<K> getKeySerializer() {
		return this.keySerializer;
	}
}
