package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import java.util.Date;

import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.datepicker.client.CalendarUtil;

/**
 * Stores page size of the table in a cookie in addition to memory.
 * 
 * @author rprakash
 */
public class CookieStoreBasedPageFeatureImpl extends PageFeatureImpl {
	private String pageSizeCookieName;
	private Date expiryDate;
	private boolean writeToCookie = true;

	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix) {
		setCookieNamePrefix(cookieNamePrefix);
		expiryDate = new Date();
		CalendarUtil.addMonthsToDate(expiryDate, 1200); // adding 100 years
	}

	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix, boolean showTotalCount) {
		super(showTotalCount);
		setCookieNamePrefix(cookieNamePrefix);
		expiryDate = new Date();
		CalendarUtil.addMonthsToDate(expiryDate, 1200); // adding 100 years
	}

	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix, int daysToExpire) {
		setCookieNamePrefix(cookieNamePrefix);
		expiryDate = new Date();
		CalendarUtil.addDaysToDate(expiryDate, daysToExpire);
	}

	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix, Date expiryDate) {
		setCookieNamePrefix(cookieNamePrefix);
		this.expiryDate = expiryDate;
	}

	private void setCookieNamePrefix(String cookieNamePrefix) {
		pageSizeCookieName = cookieNamePrefix + "_pageSize";
	}

	@Override
	public int getPageSize() {
		/* Read the value from the cookie first, then default to value in memory */
		Integer pageSize = getPageSizeFromCookie();
		return (pageSize != null) ? pageSize.intValue() : super.getPageSize();
	}

	@Override
	public void setPageSize(int size) {
		/* Set the value in 'memory' */
		super.setPageSize(size);

		/* Get the value set, and write it to the cookie */
		if (this.writeToCookie) {
			size = super.getPageSize();
			Cookies.setCookie(pageSizeCookieName, String.valueOf(size), expiryDate);
		}
	}

	@Override
	public void reset() {
		/* Reset is called by base constructor, the cookie name is not always available */
		this.writeToCookie = false;
		super.reset();
		this.writeToCookie = true;

		/* Cannot sync cookie value with memory here because cookie name is not available */
	}

	/*
	 * Get the page size from the cookie
	 */
	private Integer getPageSizeFromCookie() {
		try {
			return new Integer(Cookies.getCookie(pageSizeCookieName));
		} catch (Exception e) {
			return null;
		}
	}
}
